#pragma once
#include <library/cpp/json/writer/json_value.h>

#include <type_traits>

namespace NTemplateMaster {

template<typename T, class = std::void_t<>>
struct TIsTokenValue : std::false_type {};

template<typename T>
struct TIsTokenValue<T, std::void_t<
         decltype(std::declval<T&>() += std::declval<T>()),
         decltype(std::declval<T>() + std::declval<T>()),
         decltype(std::declval<T>() == std::declval<T>()),
         decltype(std::declval<std::hash<T>>()(std::declval<T>())),
         decltype(std::is_constructible_v<NJson::TJsonValue, T>)>
         > : std::true_type {};

template<typename T>
constexpr auto TokenValueConcept = TIsTokenValue<std::decay_t<T>>::value;

template<typename T, class = std::void_t<>>
struct TIsToken : std::false_type {};

template<typename T>
struct TIsToken<T, std::void_t<
        std::enable_if_t<TokenValueConcept<decltype(std::declval<const T&>().GetValue())>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<const T&>().IsSentinel()), bool>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<const T&>().Hash()), size_t>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<const T&>() == std::declval<const T&>()), bool>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<const T&>() != std::declval<const T&>()), bool>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<const T&>() + std::declval<const T&>()), T>, void>,
        std::enable_if_t<std::is_same_v<decltype(std::declval<T&>() += std::declval<const T&>()), T&>, void>
        >> : std::true_type {};

template<typename T>
constexpr auto TokenConcept = TIsToken<std::decay_t<T>>::value;


template<typename T>
class TToken;

template<typename T>
inline const T& GetTokenValue(const TToken<T>& token);
}


