#pragma once
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/lib/template_master/content_processor/traits.h>

#include <library/cpp/json/writer/json.h>

namespace NTemplateMaster {

using TTemplateUniqueId = uint64_t;

class TUniqueObject {
private:
    inline static std::atomic<TTemplateUniqueId> CurrentIdNumber = 0;

public:
    TUniqueObject() : UniqueId(CurrentIdNumber++) {}

    auto GetUniqueId() const noexcept {
        return UniqueId;
    }

private:
    TTemplateUniqueId UniqueId;
};

}
