#pragma once
#include <mail/yplatform/include/yplatform/find.h>
#include <mail/ymod_unistat/lib/unistat.h>

#include <string>
#include <chrono>

namespace NTemplateMaster::NUnistat {
using TClock = std::chrono::steady_clock;
using TTimePoint = decltype(TClock::now());

class TTimer {
public:
    explicit TTimer(const std::string& metric)
        : Metric(metric)
        , StartTime(TClock::now())
    {}

    ~TTimer() {
        const auto endTime = TClock::now();
        auto duration = std::chrono::duration_cast<std::chrono::milliseconds>(endTime - StartTime).count();
        yplatform::find<NYmodUnistat::IUnistat>("unistat")->Push(Metric, duration);
    }

private:
    const std::string& Metric;
    TTimePoint StartTime;
};

class TLogTimer {
public:
    TLogTimer(TContextPtr context, const std::string& metric)
        : Metric(metric)
        , StartTime(TClock::now())
        , Context(std::move(context))
    {}

    ~TLogTimer() {
        const auto endTime = TClock::now();
        auto duration = std::chrono::duration_cast<std::chrono::milliseconds>(endTime - StartTime);
        yplatform::find<NYmodUnistat::IUnistat>("unistat")->Push(Metric, duration.count());
        LOGDOG_(Context->GetLogger(), notice,
                NTemplateMaster::NLog::type=Metric,
                NTemplateMaster::NLog::duration_ms=duration)
    }

private:
    const std::string& Metric;
    TTimePoint StartTime;
    TContextPtr Context;
};

}
