#pragma once
#include <mail/template_master/lib/unistat/timer.h>
#include <mail/template_master/lib/types/expected.h>

#include <mail/ymod_unistat/lib/unistat.h>
#include <mail/yplatform/include/yplatform/find.h>
#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

#include <chrono>

namespace NTemplateMaster::NUnistat {

template<typename OperationResult>
void CollectOperationStatus(OperationResult&& result) noexcept {
    using yamail::data::serialization::to_string;

    auto unistat = yplatform::find<NYmodUnistat::IUnistat>("unistat");
    auto&& status = std::forward<OperationResult>(result).GetStatus();
    auto&& op = std::forward<OperationResult>(result).GetOperationName();
    const auto metric_name = "application_" + std::string(op.c_str()) + "_status_" + std::string(to_string(std::move(status)));
    unistat->Push(metric_name, 1);
}

template<typename T>
void CollectReturnResult(const TExpected<T>& expected, std::string metric) {
    std::string fullMetricName = "application_" + metric + "_status_";
    if (expected) {
        fullMetricName += "success";
    } else {
        fullMetricName += "error";
    }
    auto unistat = yplatform::find<NYmodUnistat::IUnistat>("unistat");
    unistat->Push(fullMetricName, 1);
}

inline void CollectHttpRequestResult(
        const boost::system::error_code& ec,
        int64_t status,
        std::string metric)
{
    std::string fullMetricName = "application_" + metric + "_status_";
    if (ec || status / 100 == 5) {
        fullMetricName += "error";
    } else {
        fullMetricName += "success";
    }
    auto unistat = yplatform::find<NYmodUnistat::IUnistat>("unistat");
    unistat->Push(fullMetricName, 1);
}

template<typename TFunction>
auto Wrap(TFunction func, std::string metric) {
    return [m = std::move(metric), f = std::move(func)](auto&&... args) mutable {
        TTimer timer(m);
        return f(std::forward<decltype(args)>(args)...);
    };
}

template<typename TFunction>
auto WrapWithLog(TFunction func, TContextPtr context, std::string metric) {
    return [m = std::move(metric), c = std::move(context), f = std::move(func)](auto&&... args) mutable {
        TLogTimer timer(c, m);
        return f(std::forward<decltype(args)>(args)...);
    };
}
}
