#pragma once
#include <mail/template_master/lib/types/time.h>
#include <mail/yreflection/include/yamail/data/reflection/reflection.h>

namespace NTemplateMaster::NDbPooler {

struct TConfig {
    size_t TasksLimitLoad;
    yplatform::time_traits::milliseconds FetchTasksInterval;
    yplatform::time_traits::milliseconds FindTimeoutTasksInterval;
    bool Enable;
};

}

YREFLECTION_ADAPT_ADT(NTemplateMaster::NDbPooler::TConfig,
    YREFLECTION_WO_MEMBER_RENAMED(size_t, tasks_limit_load, TasksLimitLoad)
        YREFLECTION_WO_MEMBER_RENAMED(bool, enable, Enable)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, fetch_tasks_interval_ms,
                yplatform::time_traits::milliseconds, FetchTasksInterval)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, find_timeout_tasks_interval_ms,
                yplatform::time_traits::milliseconds, FindTimeoutTasksInterval)
)
