#pragma once
#include <mail/template_master/lib/template_master/template_master.h>
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/worker/tasks/task.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/http/types.h>

#include <mail/yreflection/include/yamail/data/deserialization/yajl.h>
#include <mail/yreflection/include/yamail/data/reflection.h>
#include <mail/yplatform/include/yplatform/find.h>

#include <memory>
#include <iostream>

namespace NTemplateMaster::NWorker::NTask {

class TIndexFeatureContext {
public:
    TTemplateFeature Feature;
};

class TIndexFeatureTask : public ITask {
private:
    using ITemplateMaster = NTemplateMaster::NHttp::ITemplateMaster;
    using TContentProcessor = NTemplateMaster::NHttp::TContentProcessor;
    using TRequest = NTemplateMaster::THttpRouteRequest;
public:
    TIndexFeatureTask(TTaskInfo info)
        : ITask(std::move(info))
    {
        yamail::data::deserialization::fromJson(TaskInfo.Context, Context);
    }

    virtual TTaskExecutionResult Execute(TContextPtr context, TYield yield) override {
        auto db = yplatform::find<NDatabase::IDatabase>("database");
        auto res = db->IndexFeature(context, Context.Feature, yield);
        if (!res) {
            return {ETaskStatus::SUCCESS, {res.error().message()}};
        }
        return {ETaskStatus::SUCCESS, {}};
    }

    static constexpr auto Name() noexcept {
        return "index_feature";
    }
private:
    TIndexFeatureContext Context;
};

}

YREFLECTION_ADAPT_ADT(::NTemplateMaster::NWorker::NTask::TIndexFeatureContext,
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::TTemplateFeature, feature, Feature)
)
