#pragma once
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/task.h>
#include <mail/template_master/lib/types/asio.h>

#include <memory>

namespace NTemplateMaster::NWorker::NTask {

class ITask {
public:
    ITask(TTaskInfo info)
        : TaskInfo(info)
    {}

    virtual ~ITask() = default;
    virtual TTaskExecutionResult Execute(TContextPtr, TYield) = 0;

    const auto& GetTaskInfo() const noexcept {
        return TaskInfo;
    }

protected:
    TTaskInfo TaskInfo;
};

using TTaskPtr = std::shared_ptr<ITask>;
}
