#pragma once
#include <mail/template_master/lib/types/task.h>
#include <mail/template_master/lib/worker/tasks/index_template_features.h>
#include <mail/template_master/lib/worker/tasks/index_feature.h>
#include <mail/template_master/lib/utils/errors.h>

#include <boost/hana/tuple.hpp>
#include <boost/hana/for_each.hpp>
#include <boost/hana/find_if.hpp>

#include <memory>
#include <string>

namespace NTemplateMaster::NWorker::NTask {
namespace hana = boost::hana;

class TTasksRepository {
public:
    using TFactoryMap = std::map<std::string, std::function<TTaskPtr(TTaskInfo)>>;

    TTasksRepository(TFactoryMap factoryMap)
        : Factory(std::move(factoryMap))
    {}

    TExpected<TTaskPtr> CreateTask(const TTaskInfo& info) noexcept {
        const auto it = Factory.find(info.TaskType);
        if (it != Factory.end()) {
            return (*it).second(info);
        }
        const auto ec = NErrors::MakeErrorCode(NErrors::EError::UnknownTaskType);
        return yamail::make_unexpected(ec);
    }
private:
    const TFactoryMap Factory;
};

template<typename TTaskType>
decltype(auto) MakeFactory() {
    return std::make_pair(TTaskType::Name(), [](auto&& info) {
        return std::make_shared<TTaskType>(info);
    });
}

decltype(auto) MakeTasksRepository() {
    TTasksRepository::TFactoryMap m({
        MakeFactory<TIndexTemplateFeaturesTask>(),
        MakeFactory<TIndexFeatureTask>()
    });
    return std::make_shared<TTasksRepository>(m);
}

using TTasksRepositoryPtr = decltype(MakeTasksRepository());

}
