#pragma once
#include <mail/template_master/lib/worker/worker/worker.h>
#include <mail/template_master/lib/worker/tasks/tasks_repository.h>
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/asio.h>
#include <mail/template_master/lib/utils/utils.h>

#include <mail/yplatform/include/yplatform/module.h>
#include <mail/yplatform/include/yplatform/find.h>

namespace NTemplateMaster::NWorker {

class TWorker : public IWorker, public yplatform::module {
public:
    TWorker(TReactor& reactor)
        : Reactor(reactor)
        , Strand(*Reactor.io())
        , TasksRepository(NTask::MakeTasksRepository())
    {}

    virtual void RunTasks(TContextPtr context, TTasksInfos tasksInfos) override {
        for (auto&& taskInfo : tasksInfos) {
            boost::asio::spawn(Strand, [repo=TasksRepository, context=context, taskInfo=taskInfo](TYield yield) {
                auto taskExpected = repo->CreateTask(taskInfo);
                auto db = yplatform::find<NDatabase::IDatabase>("database");
                if (!taskExpected) {
                    LOGDOG_(context->GetLogger(), error, NTemplateMaster::NLog::error_code=taskExpected.error());
                    const auto finishRes = db->FinishTask(context, taskInfo.Id, ETaskStatus::FAILED, {taskExpected.error().message()}, yield);
                    if (!finishRes) {
                        LOGDOG_(context->GetLogger(), error,
                                NTemplateMaster::NLog::error_code=finishRes.error())
                    }
                } else {
                    const auto task = taskExpected.value();
                    const auto taskRes = task->Execute(context, yield);
                    const auto finishRes = db->FinishTask(context, task->GetTaskInfo().Id, taskRes.Status,
                            taskRes.Error, yield);
                    if (!finishRes) {
                        LOGDOG_(context->GetLogger(), error,
                                NTemplateMaster::NLog::error_code = finishRes.error())
                    }
                }
            }, NUtils::kCoroutineAttributes);
        }

    }

private:
    TReactor& Reactor;
    TStrand Strand;
    NTask::TTasksRepositoryPtr TasksRepository;
};

}
