#!/bin/bash
set -ex

date >&2
ls -lht /logs >&2

MIN_FREE=$((5 * 1024 * 1024)) # 5 GB
while [ "$(df -lk /logs | tail -n1 | awk '{print $4}')" -lt "$MIN_FREE" ]; do
  rm "/logs/$(ls -1t /logs | tail -n1)"
done

nice -n 19 ionice -c3 logrotate -v -s /logs/logrotate.state logrotate.d/template_master.conf "$@"
