--name: FindSimilarTemplates
SELECT stable_sign, sign, chunks as text, smlar(sign, arr) as similarity
FROM (SELECT arr, tb.*, sign & arr as matched
            FROM sherlock.template_bodies AS tb,
               ( VALUES (
                ARRAY(select DISTINCT unnest(:sign - ARRAY(SELECT feature FROM template_features WHERE feature = ANY(:sign) AND used = false)) ORDER BY 1 LIMIT :features_limit::integer)
                ) ) AS input(arr)
                    WHERE sign % arr AND search = true
                ) as m
ORDER BY smlar(sign, arr) DESC
LIMIT :limit::integer;

--name: SetSimilarThreshold
SET smlar.threshold to 0.5;

--name: SaveTemplate
WITH sign AS (SELECT * FROM unnest(:features) AS feature WHERE feature NOT IN
    (SELECT feature FROM template_features WHERE feature = ANY(:features) AND used = false) ORDER BY 1 LIMIT :features_limit::integer),
stable_sign_inserted_template_bodies AS (
    INSERT INTO template_bodies VALUES (:stable_sign::bigint, ARRAY(SELECT * from sign), :body::jsonb)
    ON CONFLICT ON CONSTRAINT template_bodies_pkey DO NOTHING RETURNING stable_sign),
stable_sign_inserted_template_meta AS (
    INSERT INTO template_meta(stable_sign, parent_templates, created, attributes, features)
        SELECT stable_sign, :parent_templates_stable_signs::bigint[], now(), :attributes::jsonb, :features::integer[]
        FROM stable_sign_inserted_template_bodies RETURNING stable_sign, features),
features AS (
    INSERT INTO template_features(feature, stable_signs)
        SELECT unnest(features), ARRAY[:stable_sign]::bigint[]
        FROM stable_sign_inserted_template_meta
    ON CONFLICT ON CONSTRAINT template_features_pkey DO NOTHING
    RETURNING *
)
SELECT stable_sign FROM stable_sign_inserted_template_bodies;

--name: FindTemplateByStableSign
SELECT stable_sign, sign, chunks from sherlock.template_bodies
WHERE stable_sign = :stable_sign::bigint;

--name: DeleteTemplate
WITH deleted_template_bodies AS (DELETE FROM template_bodies WHERE stable_sign = :stable_sign RETURNING stable_sign, sign, chunks, search),
deleted_template_meta AS (DELETE FROM template_meta WHERE stable_sign = :stable_sign RETURNING stable_sign, parent_templates, created, attributes, features)
SELECT stable_sign FROM deleted_template_bodies;

--name: SelectForUpdateSearchFlag
SELECT stable_sign FROM template_bodies WHERE stable_sign = ANY(:stable_sign_array::bigint[]) AND search = :search::boolean FOR UPDATE;

--name: UpdateSearchFlag
UPDATE template_bodies SET search = :search::boolean WHERE stable_sign = ANY(:stable_sign_array::bigint[]);

--name: IndexTemplateFeatures
INSERT INTO template_meta(stable_sign, features) VALUES (:stable_sign, :features)
ON CONFLICT (stable_sign) DO UPDATE SET features = EXCLUDED.features;

--name: UpdateFeatureStableSigns
INSERT INTO template_features VALUES (:feature, ARRAY(
SELECT stable_sign FROM template_bodies WHERE stable_sign IN
    (SELECT stable_sign FROM template_meta WHERE features && ARRAY[:feature]::integer[]) AND search = true))
ON CONFLICT (feature) DO UPDATE SET stable_signs = EXCLUDED.stable_signs;

--name: RemoveTemplateFromFeaturesIndex
UPDATE template_features SET stable_signs = array_remove(stable_signs, :stable_sign::bigint)
WHERE feature IN (SELECT feature FROM template_features WHERE stable_signs && ARRAY[:stable_sign::bigint]::bigint[]);

--name: GetReadyTasks
UPDATE sherlock.tasks
SET started = current_timestamp,
    status = 'STARTED'
WHERE id IN (
  SELECT id FROM sherlock.tasks
  WHERE status = 'NEW' AND schedule <= current_timestamp
  LIMIT :limit::integer
  FOR UPDATE SKIP LOCKED
)
RETURNING id::text, type, schedule, created, timeout, status::text, context

--name: RemoveRunningTask
DELETE FROM sherlock.tasks WHERE id = :id::uuid AND status = 'STARTED'
RETURNING id::text, type, schedule, created, started, timeout, status::text, context

--name: InsertRecentTask
INSERT INTO sherlock.recent_tasks (id, type, created, started, status, error, context)
VALUES (:id::uuid, :type, :created, :started, :status::sherlock.task_status, :error::text, :context::jsonb)

--name: GetTimeoutTask
SELECT id::text, type, schedule, created, started, timeout, status::text, context
FROM sherlock.tasks
WHERE status = 'STARTED' AND (current_timestamp - started) > timeout
FOR UPDATE SKIP LOCKED LIMIT 1

--name: GetUnusedFeatures
SELECT feature FROM template_features WHERE used = false;
