#!/bin/bash
set -exo pipefail

export DATA_DIR=/data
export ZOO_CLIENT_PORT=2222
export ZOO_HTTP_PORT=2223
export ZOO_VOTE_PORT=2224
export ZOO_DATA_PORT=2225
export ADDITIONAL_ARGS="
-DPORTO=1
-XX:ActiveProcessorCount=3
-Dru.yandex.lucene.default-cache-size=48000000
-Dru.yandex.lucene-storage.max-live-data-size=48000000
-Dru.yandex.lucene-storage.max-cache-weight=48000000
-Dru.yandex.lucene-storage.max-segment-size=$((128 * 1024 * 1024))
-Dru.yandex.lucene-queue.ram-buffer-size-mb=48
-Dru.yandex.lucene-storage.zoo-hash-bloom-filter=false
-Dru.yandex.lucene-storage.in-memory-fields-index=false"

export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
export ZSTD=true
export SNAP_COUNT=100000

export GCLOGS_DIR=${GCLOGS_DIR:-/dev/shm/gclogs}

export MEMORY_GAP=$((1024*1024*1024))

# for watchdog
export BSCONFIG_IPORT=$ZOO_CLIENT_PORT


