#include <mail/template_master/lib/db/operations/save_template.h>
#include <mail/template_master/ut/mock/connection_provider_mock.h>
#include <mail/template_master/ut/mock/query_repository_mock.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>
#include <chrono>

namespace NTemplateMaster::NTests {

using namespace std::chrono_literals;
using ::testing::Return;
using ::testing::_;
using ::testing::InSequence;

template<typename T>
using TSaveTemplateOp = NTemplateMaster::NDatabase::Operations::TSaveTemplateOp<T>;

class TSaveTemplateTest : public TTestBase, public TWithSpawn {
    UNIT_TEST_SUITE(TSaveTemplateTest)
        UNIT_TEST(Success)
        UNIT_TEST(Error)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Io = std::make_unique<boost::asio::io_context>();
        Context = GetContext();
    }

    void Success() {
        Spawn([=](TYield yield) {
            const InSequence s;
            TQueryRepository queryRepo;
            queryRepo.mock = GetQueryRepositoryMock();
            auto connProvider = GetConnectionProviderMock();
            TTemplateStableSign stableSign(123);
            TTemplateFeaturesSet sign({1, 2, 3});
            std::string body(R"([["1", "2"], ["3"]])");
            TDatabaseTemplatePtr templ = std::make_shared<TDatabaseTemplate>(stableSign, sign, body, TJsonAttributesArray{});
            TSaveTemplateOp<decltype(queryRepo)> op(queryRepo, templ, 3, {});

            EXPECT_CALL(*queryRepo.mock, make_query())
                    .WillOnce(Return(FakeQuery()));

            EXPECT_CALL(*connProvider, Begin(_))
                    .WillOnce(Return(boost::system::error_code()));

            EXPECT_CALL(*connProvider, Execute(_, _))
                    .WillOnce(Return(boost::system::error_code()));

            EXPECT_CALL(*connProvider, Commit(_))
                    .WillOnce(Return(boost::system::error_code()));

            auto res = op(Context, connProvider, 1s, yield);
            EXPECT_TRUE(res);
        });
    }

    void Error() {
        Spawn([=](TYield yield) {
            const InSequence s;
            TQueryRepository queryRepo;
            queryRepo.mock = GetQueryRepositoryMock();
            auto connProvider = GetConnectionProviderMock();
            TTemplateStableSign stableSign(123);
            TTemplateFeaturesSet sign({1, 2, 3});
            std::string body(R"([["1", "2"], ["3"]])");
            TDatabaseTemplatePtr templ = std::make_shared<TDatabaseTemplate>(stableSign, sign, body, TJsonAttributesArray{});
            TSaveTemplateOp<decltype(queryRepo)> op(queryRepo, templ, 3, {});

            EXPECT_CALL(*queryRepo.mock, make_query())
                    .WillOnce(Return(FakeQuery()));

            EXPECT_CALL(*connProvider, Begin(_))
                    .WillOnce(Return(boost::system::error_code()));

            auto ec = boost::system::errc::make_error_code(boost::system::errc::not_supported);
            EXPECT_CALL(*connProvider, Execute(_, _))
                    .WillOnce(Return(ec));

            auto res = op(Context, connProvider, 1s, yield);
            EXPECT_FALSE(res);
            EXPECT_EQ(res.error(), ec);
        });
    }
private:
    NTemplateMaster::TContextPtr Context;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TSaveTemplateTest);
