#include <mail/template_master/lib/db/operations/update_search_flag.h>
#include <mail/template_master/ut/mock/connection_provider_mock.h>
#include <mail/template_master/ut/mock/query_repository_mock.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>
#include <chrono>

namespace NTemplateMaster::NTests {

using namespace std::chrono_literals;
using ::testing::Return;
using ::testing::_;
using ::testing::InSequence;

template<typename T>
using TUpdateSearchFlagOp = NTemplateMaster::NDatabase::Operations::TUpdateSearchFlagOp<T>;

class TUpdateSearchFlagTest : public TTestBase, public TWithSpawn {
    UNIT_TEST_SUITE(TUpdateSearchFlagTest)
        UNIT_TEST(Success)
        UNIT_TEST(Error)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Io = std::make_unique<boost::asio::io_context>();
        Context = GetContext();
    }

    void Success() {
        Spawn([=](TYield yield) {
            const InSequence s;
            TQueryRepository queryRepo;
            queryRepo.mock = GetQueryRepositoryMock();
            auto connProvider = GetConnectionProviderMock();
            TTemplateStableSign stableSign(123);
            TUpdateSearchFlagOp<decltype(queryRepo)> op(queryRepo, true,  {stableSign});

            EXPECT_CALL(*queryRepo.mock, make_query())
                    .WillOnce(Return(FakeQuery()));

            EXPECT_CALL(*connProvider, Begin(_))
                    .WillOnce(Return(boost::system::error_code()));

            EXPECT_CALL(*connProvider, Execute(_, _))
                    .WillOnce(Return(boost::system::error_code()));

            EXPECT_CALL(*connProvider, Commit(_))
                    .WillOnce(Return(boost::system::error_code()));

            auto res = op(Context, connProvider, 1s, yield);
            EXPECT_TRUE(res);
        });
    }

    void Error() {
        Spawn([=](TYield yield) {
            const InSequence s;
            TQueryRepository queryRepo;
            queryRepo.mock = GetQueryRepositoryMock();
            auto connProvider = GetConnectionProviderMock();
            TTemplateStableSign stableSign(123);
            TUpdateSearchFlagOp<decltype(queryRepo)> op(queryRepo, true,  {stableSign});

            EXPECT_CALL(*queryRepo.mock, make_query())
                    .WillOnce(Return(FakeQuery()));

            EXPECT_CALL(*connProvider, Begin(_))
                    .WillOnce(Return(boost::system::error_code()));

            EXPECT_CALL(*connProvider, Execute(_, _))
                    .WillOnce(Return(boost::system::error_code()));
            auto ec = boost::system::errc::make_error_code(boost::system::errc::not_supported);
            EXPECT_CALL(*connProvider, Commit(_))
                    .WillOnce(Return(ec));

            auto res = op(Context, connProvider, 1s, yield);
            EXPECT_FALSE(res);
        });
    }
private:
    NTemplateMaster::TContextPtr Context;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TUpdateSearchFlagTest);
