#pragma once
#include <mail/template_master/ut/mock/db_mock.h>
#include <mail/template_master/ut/mock/unistat_mock.h>
#include <mail/template_master/ut/mock/router_mock.h>
#include <mail/template_master/ut/mock/http_client_mock.h>
#include <mail/template_master/ut/mock/template_master_mock.h>

#include <mail/yplatform/include/yplatform/application.h>

namespace NTemplateMaster::NTests {

class TTestsEnvironment {
    const std::string config =R"(config:
     system:
         dir: .
     log:
     modules:
         module:
         -   system:
                 name: unistat
                 factory: NTemplateMaster::NTests::TUnistatMock
             configuration: {}
         -   system:
                 name: database
                 factory: NTemplateMaster::NTests::TDatabaseMock
             configuration: {}
         -   system:
                  name: router
                  factory: NTemplateMaster::NTests::TRouterMock
             configuration: {}
         -   system:
                  name: http_client
                  factory: NTemplateMaster::NTests::THttpClientMock
             configuration: {}
         -   system:
                  name: template_master
                  factory: NTemplateMaster::NTests::TTemplateMasterMock
             configuration: {})";

    TTestsEnvironment() {
        yplatform::configuration conf;
        conf.load_from_str(config);
        Application = std::make_unique<yplatform::application>(conf);
        Application->run();
    }

public:
    virtual ~TTestsEnvironment() {
        Application->stop();
    }

    static TTestsEnvironment& SetUp() {
        static TTestsEnvironment env;
        return env;
    }

    std::unique_ptr<yplatform::application> Application;
};

}
