#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/template/database_template.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/ut/mock/template_mock.h>

#include <mail/yplatform/include/yplatform/module_registration.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TDatabaseMock: public NTemplateMaster::NDatabase::IDatabase {
public:
    MOCK_METHOD(TExpected<TDatabaseTemplates>, FindSimilarTemplates, (
            NTemplateMaster::TContextPtr,
            const TTemplateFeaturesSet&,
            int32_t,
            int32_t,
            TYield), (override));

    MOCK_METHOD(TExpected<TOptional<TDatabaseTemplatePtr>>, FindTemplateByStableSign, (
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, SaveTemplate, (
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            TYield), (override));

    MOCK_METHOD(TExpected<size_t>, DeleteTemplate, (
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, IndexTemplateFeatures, (
            NTemplateMaster::TContextPtr,
            TTemplateFeaturesSet,
            TTemplateStableSign,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, RemoveTemplateFromFeaturesIndex, (
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, IndexFeature, (
            NTemplateMaster::TContextPtr,
            TTemplateFeature,
            TYield), (override));

    MOCK_METHOD(TExpected<TTemplateFeaturesSet>, GetUnusedFeatures, (
            NTemplateMaster::TContextPtr,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, UpdateSearchFlag, (
            NTemplateMaster::TContextPtr,
            bool,
            TTemplatesStableSigns,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, MoveTimeoutTask, (
            NTemplateMaster::TContextPtr,
            TYield), (override));

    MOCK_METHOD(TExpected<TTasksInfos>, GetReadyTasks, (
            NTemplateMaster::TContextPtr,
            int32_t,
            TYield), (override));

    MOCK_METHOD(TExpected<void>, FinishTask, (
            NTemplateMaster::TContextPtr,
            std::string,
            ETaskStatus,
            TOptional<std::string>,
            TYield yield), (override));

    MOCK_METHOD(void, AsyncSaveTemplate, (
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            std::function<void(TExpected<void>)>), (override));

    MOCK_METHOD(void, AsyncMergeTemplates, (
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            std::function<void(TExpected<bool>)>), (override));
};

using TDatabaseMockPtr = std::shared_ptr<StrictMock<TDatabaseMock>>;

inline auto GetDbMock() noexcept {
    return std::make_shared<StrictMock<TDatabaseMock>>();
}

}

REGISTER_MODULE(NTemplateMaster::NTests::TDatabaseMock)
