#pragma once
#include <mail/template_master/lib/types/http.h>

#include <mail/ymod_httpclient/include/ymod_httpclient/call.h>
#include <mail/yplatform/include/yplatform/module_registration.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class THttpClientMock: public ymod_httpclient::simple_call, public yplatform::module {
public:
    MOCK_METHOD(THttpResponse, run, (task_context_ptr, THttpRequest), (override));
    MOCK_METHOD(THttpResponse, run, (task_context_ptr, THttpRequest, const THttpOptions&), (override));
    MOCK_METHOD(void, async_run, (task_context_ptr, THttpRequest, callback_type), (override));
    MOCK_METHOD(void, async_run, (task_context_ptr, THttpRequest, const THttpOptions&, callback_type), (override));
};

using THttpClientPtr = std::shared_ptr<StrictMock<THttpClientMock>>;

inline auto GetHttpClientMock() {
    return std::make_shared<StrictMock<THttpClientMock>>();
}
}

REGISTER_MODULE(NTemplateMaster::NTests::THttpClientMock)
