#pragma once
#include <mail/template_master/lib/template_pool/cache/min_hash.h>
#include <mail/template_master/ut/mock/template_mock.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TMinHashMock {
public:
    MOCK_METHOD(NTemplateMaster::NTemplatePool::TMinHash<TMockTemplatePtr>::TBuckets, GetBuckets, (), (const));
    MOCK_METHOD(void, InsertTemplate, (TMockTemplatePtr), ());
    MOCK_METHOD(std::unordered_set<TTemplateUniqueId>, FindSimilarTemplates, (TMessagePtr), (const));
    MOCK_METHOD(void, EraseTemplate, (TMockTemplatePtr), ());
};

using TMinHashMockPtr = std::shared_ptr<StrictMock<TMinHashMock>>;

inline auto GetMinHashMock() {
    return std::make_shared<StrictMock<TMinHashMock>>();
}

}
