#pragma once
#include <mail/template_master/lib/types/time.h>
#include <mail/template_master/lib/router/node.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TNodeMock : public NTemplateMaster::NRouter::INode {
public:
    MOCK_METHOD(const std::string&, GetAddress, (), (const, override));

    MOCK_METHOD(bool, IsLocal, (), (const));

    MOCK_METHOD(bool, IsBanned, (), (const, override));

    MOCK_METHOD(TDuration, Ban, (TDuration), (override));

    MOCK_METHOD(int, ResetBan, (), (override));
};

using TNodeMockPtr = std::shared_ptr<StrictMock<TNodeMock>>;

inline auto GetNodeMock() {
    return std::make_shared<StrictMock<TNodeMock>>();
}

}
