#pragma once
#include <mail/template_master/lib/types/time.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TNowMock {
public:
    MOCK_METHOD(TTimePoint, Now, (), (const));
};

using TNowMockPtr = std::shared_ptr<StrictMock<TNowMock>>;
using TGetNow = std::function<decltype(std::declval<TNowMock>().Now())()>;

inline auto GetNowMock() {
    return std::make_shared<StrictMock<TNowMock>>();
}
}
