#pragma once
#include <mail/template_master/lib/db/queries/query.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/asio.h>

#include <ozo/error.h>
#include <ozo/time_traits.h>
#include <ozo/shortcuts.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <type_traits>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;
using namespace NDatabase::NQuery;

struct FakeQuery {
    BOOST_HANA_DEFINE_STRUCT(FakeQuery,
            (std::int64_t, param)
    );

    using parameters_type = FakeQuery;
    using result_type = std::tuple<std::int64_t>;

    friend FakeQuery get_text(FakeQuery self) {
        return self;
    }

    friend const char* to_const_char(FakeQuery) {
        return "query name";
    }
};

class TQueryRepositoryMock {
public:
    MOCK_METHOD(FakeQuery, make_query, (), (const));
};

using TQueryRepositoryMockPtr = std::shared_ptr<StrictMock<TQueryRepositoryMock>>;

inline auto GetQueryRepositoryMock() noexcept {
    return std::make_shared<StrictMock<TQueryRepositoryMock>>();
}


class TQueryRepository {
public:
    TQueryRepositoryMockPtr mock;

    template<typename TQuery>
    FakeQuery make_query(const typename TQuery::parameters_type&) const noexcept {
        return mock->make_query();
    }

    template<typename TQuery>
    FakeQuery make_query() const noexcept {
        return mock->make_query();
    }
};

}
