#pragma once
#include <mail/template_master/lib/db/shard_resolver.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/asio.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <utility>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TResolverMock {
public:
    MOCK_METHOD((std::pair<::sharpei::client::MapShard, boost::system::error_code>), GetAllShards, (), (const));
};

using TResolverMockPtr = std::shared_ptr<StrictMock<TResolverMock>>;

inline auto GetResolverMock() noexcept {
    return std::make_shared<StrictMock<TResolverMock>>();
}

class TResolver {
public:
    TResolverMockPtr mock;

    auto GetAllShards(TContextPtr, TYield yield) {
        auto&& [mapShard, ec] = mock->GetAllShards();
        *yield.ec_ = ec;
        return mapShard;
    }
};

}
