#pragma once
#include <mail/template_master/lib/types/http.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/router/router_module.h>

#include <mail/yplatform/include/yplatform/module_registration.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TRouterMock: public NTemplateMaster::NRouter::IRouter {
public:
    MOCK_METHOD(TExpected<THttpResponse>, SendRequest, (
            NTemplateMaster::TContextPtr,
            std::string body,
            TTemplateFeaturesSet features,
            TYield), (override));

    MOCK_METHOD(TOptional<std::string>, GetDC, (), (const, override));
};

using TRouterMockPtr = std::shared_ptr<StrictMock<TRouterMock>>;

inline auto GetRouterMock() noexcept {
    return std::make_shared<StrictMock<TRouterMock>>();
}

}

REGISTER_MODULE(NTemplateMaster::NTests::TRouterMock)
