#pragma once
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/ut/utils.h>
#include <mail/template_master/ut/mock/template_mock.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TTemplateCacheMock {
public:
    MOCK_METHOD(size_t, Size, (), (const));
    MOCK_METHOD(void, InsertTemplate, (TMockTemplatePtr), ());
    MOCK_METHOD(void, InsertTemplate, (TUnstableTemplatePtr), ());
    MOCK_METHOD(TOptional<TMockTemplatePtr>, FindTemplateById, (TTemplateUniqueId), (const));
    MOCK_METHOD(void, UpdateTemplate, (TMockTemplatePtr, TTokenSequence<TTokenType>), ());
    MOCK_METHOD(std::unordered_set<TTemplateUniqueId>, FindSimilarTemplates, (TMockTemplatePtr), (const));
    MOCK_METHOD(std::unordered_set<TTemplateUniqueId>, FindSimilarTemplates, (TMessagePtr), (const));
    MOCK_METHOD(void, PromoteTemplate, (TMockTemplatePtr), ());
    MOCK_METHOD(void, EraseTemplate, (TMockTemplatePtr), ());
};

using TTemplateCacheMockPtr = std::shared_ptr<StrictMock<TTemplateCacheMock>>;

inline auto GetTemplateCacheMock() noexcept {
    return std::make_shared<StrictMock<TTemplateCacheMock>>();
}

}
