#pragma once
#include <mail/template_master/lib/types/template/database_template.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/template_master/template_master.h>
#include <mail/template_master/ut/mock/template_mock.h>
#include <mail/template_master/ut/utils.h>

#include <mail/yplatform/include/yplatform/module_registration.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TTemplateMasterMock: public ITemplateMaster<TContentProcessor, TRequest, TMockTemplatePtr> {
public:
    MOCK_METHOD(TExpected<TDatabaseTemplates>, FindSimilarTemplates, (
            NTemplateMaster::TContextPtr,
            TMockTemplatePtr,
            TYield), (override));

    MOCK_METHOD(void, MergeTemplates, (
            NTemplateMaster::TContextPtr,
            TStableTemplates), (override));

    MOCK_METHOD(TContentProcessorPtr, GetContentProcessor, (), (const, override));

    MOCK_METHOD(int, GetMaxHashesCount, (), (const, override));

    MOCK_METHOD(TTemplatePoolPtr<TMockTemplatePtr>, FindTemplatePool, (), (override));
};

using TTemplateMasterMockPtr = std::shared_ptr<StrictMock<TTemplateMasterMock>>;

inline auto GetTemplateMasterMock() noexcept {
    return std::make_shared<StrictMock<TTemplateMasterMock>>();
}

}

REGISTER_MODULE(NTemplateMaster::NTests::TTemplateMasterMock)
