#pragma once
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TMockTemplate;
using TMockTemplatePtr = std::shared_ptr<StrictMock<TMockTemplate>>;

class TMockTemplate {
public:
    virtual ~TMockTemplate() = default;

    MOCK_METHOD(TTemplateFeaturesSet, GetFeatures, (), (const));
    MOCK_METHOD(void, UpdateTokens, (const TStringTokenSequence&), ());
    MOCK_METHOD(size_t, GetUniqueId, (), (const));
    MOCK_METHOD(TMockTemplatePtr, CreateUnstableTemplate, (), ());
    MOCK_METHOD(TMockTemplatePtr, CreateStableTemplate, (), (const));
    MOCK_METHOD(const TStringTokenSequence&, GetTokens, (), (const));
    MOCK_METHOD(size_t, Size, (), (const));
    MOCK_METHOD(TContentProcessor, GetContentProcessor, (), (const));
    MOCK_METHOD(size_t, GetHits, (), (const));
    MOCK_METHOD(TAttributesArray<TAttributes>, GetAttributesArray, (), (const));
    MOCK_METHOD(TAttributes, GetAttributes, (), (const));
    MOCK_METHOD(void, PushAttributes, (TAttributes), ());
    MOCK_METHOD(void, IncrementHits, (), ());
    MOCK_METHOD(TTemplateStableSign, GetStableSign, (), (const));
    MOCK_METHOD(THttpRouteRequest, GetContent, (), (const));
};

inline auto GetTemplateMock() {
    return std::make_shared<StrictMock<TMockTemplate>>();
}

}
