#pragma once
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/template_pool/template_pool.h>
#include <mail/template_master/ut/mock/template_mock.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TTemplatePoolMock : public NTemplateMaster::NTemplatePool::ITemplatePool
        <TContentProcessor, TRequest, TMockTemplatePtr, TDbHints> {
public:
    MOCK_METHOD((TDetempleResult<TTokenType, TAttributes>), AddToPool, (
            NTemplateMaster::TContextPtr,
            TMockTemplatePtr,
            std::optional<TDbHints>,
            TYield), (override));
};

using TTemplatePoolMockPtr = std::shared_ptr<StrictMock<TTemplatePoolMock>>;

inline auto GetTemplatePoolMock() noexcept {
    return std::make_shared<StrictMock<TTemplatePoolMock>>();
}

}
