#pragma once
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/template/database_template.h>
#include <mail/template_master/ut/mock/template_mock.h>
#include <mail/template_master/ut/mock/db_mock.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <vector>

namespace NTemplateMaster::NTests {

using ::testing::StrictMock;

class TGetCandidateTemplatesOperationMock {
public:
    MOCK_METHOD(std::vector<decltype(GetTemplateMock())>, GetCandidateTemplates, (
            NTemplateMaster::TContextPtr,
            TMockTemplatePtr), (const));
};

using TGetCandidateTemplatesOperationMockPtr = std::shared_ptr<StrictMock<TGetCandidateTemplatesOperationMock>>;

inline auto GetGetCandidateTemplatesOperationMock() {
    return std::make_shared<StrictMock<TGetCandidateTemplatesOperationMock>>();
}

using TMatchTemplateMock = std::pair<decltype(GetTemplateMock()), TMatchResult<TTokenType>>;

using TAdaptedTemplate = TDatabaseTemplateDetempleAdaptorPtr<TContentProcessor, NTemplateMaster::THttpRouteRequest>;
using TMatchDbTemplate = std::pair<TAdaptedTemplate, TMatchResult<TTokenType>>;

class TCalculateBestMatchOperationMock {
public:
    MOCK_METHOD(TOptional<TMatchTemplateMock>, GetBestMatch, (
            NTemplateMaster::TContextPtr,
            TMockTemplatePtr,
            std::vector<TMockTemplatePtr>), (const));

    MOCK_METHOD(TOptional<TMatchDbTemplate>, GetBestMatch, (
            NTemplateMaster::TContextPtr,
            TMockTemplatePtr,
            std::vector<TAdaptedTemplate>), (const));
};

using TCalculateBestMatchOperationMockPtr = std::shared_ptr<StrictMock<TCalculateBestMatchOperationMock>>;

inline auto GetCalculateBestMatchOperationMock() {
    return std::make_shared<StrictMock<TCalculateBestMatchOperationMock>>();
}

class TSaveReadyTemplateOperationMock {
public:
    MOCK_METHOD(void, Save, (NTemplateMaster::TContextPtr,
            TMockTemplatePtr,
            NDatabase::TDatabasePtr), (const));
};

using TSaveReadyTemplateOperationMockPtr = std::shared_ptr<StrictMock<TSaveReadyTemplateOperationMock>>;

inline auto GetSaveReadyTemplateOperationMock() {
    return std::make_shared<StrictMock<TSaveReadyTemplateOperationMock>>();
}
}
