#pragma once
#include <mail/ymod_unistat/lib/unistat.h>
#include <mail/yplatform/include/yplatform/module.h>
#include <mail/yplatform/include/yplatform/module_registration.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace NTemplateMaster::NTests {

class TUnistatMock: public NYmodUnistat::IUnistat, public yplatform::module {
public:
    MOCK_METHOD(void, Push, (const std::string&, double), (override));

    MOCK_METHOD(NYmodUnistat::TMetric::TValue, GetValue, (
            const std::string&,
            bool), (override));

    MOCK_METHOD(TValues, GetValues, (bool), (override));

    MOCK_METHOD(std::string, GetValuesInJson, (bool), (override));

    MOCK_METHOD(void, ResetAll, (), (override));

    NYmodUnistat::TMetricPtr SetHandler(
            const std::string&,
            NYmodUnistat::TMetricPtr) override
    {
        return nullptr;
    }

    MOCK_METHOD(void, AddMetric, (const yplatform::ptree&), (override));
    MOCK_METHOD(bool, IsMetricPresent, (const std::string&), (override));
};

}

REGISTER_MODULE(NTemplateMaster::NTests::TUnistatMock)
