#include <mail/template_master/lib/router/node_manager.h>
#include <mail/template_master/lib/router/node.h>
#include <mail/template_master/ut/mock/node_mock.h>

#include <library/cpp/testing/unittest/registar.h>

#include <chrono>

namespace NTemplateMaster::NTests {

using TNodeManager = NTemplateMaster::NRouter::TNodeManager;
using TNodePtr = NTemplateMaster::NRouter::TNodePtr;
using ::testing::Return;
using ::testing::InSequence;

template<typename T>
using TNode = NTemplateMaster::NRouter::TNode<T>;

Y_UNIT_TEST_SUITE(TNodeManagerTest) {

Y_UNIT_TEST(GetAvailableNodes) {
    InSequence s;
    auto nodeAvail1 = std::make_shared<TNodeMock>();
    auto nodeAvail2 = std::make_shared<TNodeMock>();
    auto nodeBan = std::make_shared<TNodeMock>();
    EXPECT_CALL(*nodeAvail1, IsBanned()).WillOnce(Return(false));
    EXPECT_CALL(*nodeAvail2, IsBanned()).WillOnce(Return(false));
    EXPECT_CALL(*nodeBan, IsBanned()).WillOnce(Return(true));
    std::vector<TNodePtr> nodes({nodeAvail1, nodeAvail2, nodeBan});
    TNodeManager manager(nodes);
    std::vector<TNodePtr> expectedNodes({nodeAvail1, nodeAvail2});
    auto availNodes = manager.GetAvailableNodes();
    std::sort(availNodes.begin(), availNodes.end());
    std::sort(expectedNodes.begin(), expectedNodes.end());
    ASSERT_EQ(availNodes, expectedNodes);
}

}

}

