#include <mail/template_master/lib/router/node.h>
#include <mail/template_master/ut/mock/now_mock.h>

#include <library/cpp/testing/unittest/registar.h>

#include <chrono>

namespace NTemplateMaster::NTests {

using namespace std::chrono_literals;
using ::testing::Return;
using ::testing::InSequence;

template<typename T>
using TNode = NTemplateMaster::NRouter::TNode<T>;

class TNodeTest : public TTestBase {
    UNIT_TEST_SUITE(TNodeTest)
        UNIT_TEST(BaseOperations)
        UNIT_TEST(Ban)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Now = GetNowMock();
        GetNow = [now=Now]() {
            return now->Now();
        };
    }

    void BaseOperations() {
        const auto address = "sas1-eb4011aad846.qloud-c.yandex.net";
        TNode<TGetNow> node(address, GetNow);
        ASSERT_EQ(node.GetAddress(), address);
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 1s));
        ASSERT_FALSE(node.IsBanned());
    }

    void Ban() {
        InSequence s;
        const auto address = "sas1-eb4011aad846.qloud-c.yandex.net";
        TNode<TGetNow> node(address, GetNow);
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 1s));
        ASSERT_EQ(node.Ban(2s), 2s);
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 1s));
        ASSERT_TRUE(node.IsBanned());
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 4s));
        ASSERT_EQ(node.Ban(2s), 4s);
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 9s));
        ASSERT_EQ(node.Ban(2s), 6s);
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 11s));
        ASSERT_TRUE(node.IsBanned());
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 16s));
        ASSERT_FALSE(node.IsBanned());
        node.ResetBan();
        EXPECT_CALL(*Now, Now()).WillOnce(Return(TTimePoint::min() + 1s));
        ASSERT_FALSE(node.IsBanned());
    }
private:
    TNowMockPtr Now;
    TGetNow GetNow;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TNodeTest)
