#include <mail/template_master/lib/template_master/handlers/delete_template_handler.h>
#include <mail/template_master/ut/mock/db_mock.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>

namespace NTemplateMaster::NTests {

using ::testing::Return;
using ::testing::_;
using ::testing::InSequence;
using TDeleteTemplateHandler = NTemplateMaster::NHandlers::TDeleteTemplateHandler;

class TDeleteTemplateHandlerTest : public TTestBase, public TWithSpawn {
    UNIT_TEST_SUITE(TDeleteTemplateHandlerTest)
        UNIT_TEST(Success)
        UNIT_TEST(Error)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Io = std::make_unique<boost::asio::io_context>();
        Context = GetContext();
    }

    void Success() {
        Spawn([=](TYield yield) {
            const InSequence s;
            auto dbMock = GetDbMock();
            const TTemplateStableSign stableSign = 123;
            const TTemplateFeaturesSet sign({});
            const std::string json(R"([["1", "2"], ["3"]])");
            auto dbTemplate = std::make_shared<TDatabaseTemplate>(stableSign, sign, json, TJsonAttributesArray{});
            const size_t deletedTemplatesCount = 1;

            TDeleteTemplateHandler deleteTemplateHandler(Context, stableSign, dbMock);
            EXPECT_CALL(*dbMock, DeleteTemplate(Context, stableSign, _))
                    .WillOnce(Return(TExpected<size_t>(deletedTemplatesCount)));

            const auto result = deleteTemplateHandler(yield);
            EXPECT_EQ(result.Status, EDeleteStatus::Success);
            EXPECT_TRUE(result.DeletedTemplatesCount.has_value());
            EXPECT_EQ(result.DeletedTemplatesCount.value(), deletedTemplatesCount);
        });
    }

    void Error() {
        Spawn([=](TYield yield) {
            const InSequence s;
            auto dbMock = GetDbMock();
            const TTemplateStableSign stableSign = 123;
            const TTemplateFeaturesSet sign({});
            const std::string json(R"([["1", "2"], ["3"]])");
            auto dbTemplate = std::make_shared<TDatabaseTemplate>(stableSign, sign, json, TJsonAttributesArray{});

            TDeleteTemplateHandler deleteTemplateHandler(Context, stableSign, dbMock);
            auto ec = boost::system::errc::make_error_code(boost::system::errc::not_supported);
            EXPECT_CALL(*dbMock, DeleteTemplate(Context, stableSign, _))
                    .WillOnce(Return(yamail::make_unexpected(ec)));

            const auto result = deleteTemplateHandler(yield);
            EXPECT_EQ(result.Status, EDeleteStatus::Error);
        });
    }
private:
    NTemplateMaster::TContextPtr Context;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TDeleteTemplateHandlerTest);
