#include <mail/template_master/lib/template_master/handlers/detemple_handler.h>
#include <mail/template_master/ut/mock/template_master_mock.h>
#include <mail/template_master/ut/mock/template_pool_mock.h>
#include <mail/template_master/ut/environment.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>

namespace NTemplateMaster::NTests {

using ::testing::Return;
using ::testing::ReturnRef;
using ::testing::_;
using ::testing::InSequence;
using TDetempleTemplateHandler = NTemplateMaster::NHandlers::TDetempleHandler<
        TContentProcessor, TRequest, TMockTemplatePtr>;

class TDetempleHandlerTest : public TTestBase, public TWithSpawn {
    UNIT_TEST_SUITE(TDetempleHandlerTest)
//        UNIT_TEST(BaseTest)
        UNIT_TEST(EmptyMessage)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        TTestsEnvironment::SetUp();
        Io = std::make_unique<boost::asio::io_context>();
        Context = GetContext();
        ContentProcessor = CreateContentProcessor(3);
    }

    void BaseTest() {
        Spawn([=](TYield yield) {
            const InSequence s;
            auto templateMasterMock = GetTemplateMasterMock();
            auto templatePoolMock = GetTemplatePoolMock();
            auto msg = GetTemplateMock();
            auto expectedRes = TDetempleResult<TTokenType, TAttributes>();
            expectedRes.StableSign = 18;
            EXPECT_CALL(*msg, GetFeatures()).WillOnce(Return(TTemplateFeaturesSet()));
            EXPECT_CALL(*msg, Size()).WillOnce(Return(1));
            EXPECT_CALL(*templateMasterMock, FindTemplatePool()).WillOnce(Return(templatePoolMock));
            EXPECT_CALL(*templatePoolMock, AddToPool(Context, msg, _,  _)).WillOnce(Return(expectedRes));
            TDetempleTemplateHandler detempleTemplateHandler(Context, msg, templateMasterMock, std::nullopt);
            const auto result = detempleTemplateHandler(yield);
            EXPECT_EQ(result, expectedRes);
        });
    }

    void EmptyMessage() {
        Spawn([=](TYield yield) {
            const InSequence s;
            auto templateMasterMock = GetTemplateMasterMock();
            auto templatePoolMock = GetTemplatePoolMock();
            auto msg = GetTemplateMock();
            const auto expectedRes = TDetempleResult<TTokenType, TAttributes>();
            EXPECT_CALL(*msg, GetFeatures()).WillOnce(Return(TTemplateFeaturesSet()));
            EXPECT_CALL(*msg, Size()).WillOnce(Return(0));
            TDetempleTemplateHandler detempleTemplateHandler(Context, msg, templateMasterMock, std::nullopt);
            const auto result = detempleTemplateHandler(yield);
            EXPECT_EQ(result.Status, EDetempleStatus::NotFound);
        });
    }

private:
    NTemplateMaster::TContextPtr Context;
    TContentProcessorPtr ContentProcessor;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TDetempleHandlerTest);
