#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/lib/types/operation_request/email_http_request.h>
#include <mail/template_master/lib/template_pool/cache/min_hash.h>
#include <mail/template_master/lib/template_master/content_processor/traits.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/lib/template_pool/operations/calculate_best_match.h>
#include <mail/template_master/ut/utils.h>
#include <mail/template_master/ut/environment.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>

namespace NTemplateMaster::NTests {

using NTemplateMaster::NTemplatePool::TCalculateBestMatchOperation;

class TCalculateBestMatchOpTest: public TTestBase {
    UNIT_TEST_SUITE(TCalculateBestMatchOpTest)
        UNIT_TEST(MatchFirstSuitableTemplate)
        UNIT_TEST(NoMatchWithTemplatesWhichHaveManyHits)
        UNIT_TEST(NoMatchWithTemplatesWhichHaveNoRequiredCommonPart)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Context = GetContext();
        TTestsEnvironment::SetUp();
    }

    void MatchFirstSuitableTemplate() {
        TCalculateBestMatchOperation<TContentProcessor, TRequest> Op(1.1, 0.6, 1);
        const auto sp = CreateContentProcessor(1);
        const auto msg = CreateMessagePtr("<1><2><3><4><5><6><7><8><9><10>", "", "", "", sp);
        auto t1 = CreateUnstableTemplate("<1><2><4><5><6><13><7><10>", "", "", "", sp);
        auto t2 = CreateUnstableTemplate("<1><2><3><4><5><6><7><8><9><10>", "", "", "", sp);
        TUnstableTemplates<TContentProcessor, TRequest> templates;
        templates.emplace_back(t1);
        templates.emplace_back(t2);
        const auto result = Op.GetBestMatch(Context, msg, templates);
        EXPECT_TRUE(result.has_value());
        EXPECT_EQ(result.value().first, t1);
        auto match = result.value().second;
        EXPECT_DOUBLE_EQ(match.GetCommonPartPercent(), 0.875);
        auto seq = BuildTokenSequence(sentinel, "<1>", "<2>", sentinel, "<4>", "<5>", "<6>", sentinel, "<7>", sentinel, "<10>", sentinel);
        EXPECT_TRUE(Compare(match.GetCommonPart(), seq));
    }

    void NoMatchWithTemplatesWhichHaveManyHits() {
        TCalculateBestMatchOperation<TContentProcessor, TRequest> Op(1.1, 0.6, 1);
        const auto sp = CreateContentProcessor(1);
        const auto msg = CreateMessagePtr("<1><2><3><4><5><6><7><8><9><10>", "", "", "", sp);
        auto t1 = CreateUnstableTemplate("<1><2><4><5><6><13><7><10>", "", "", "", sp);
        AddHits(t1, 8);
        auto t2 = CreateUnstableTemplate("<1><2><3><4><55><6><7><8><9><10>", "", "", "", sp);
        AddHits(t2, 10);
        TUnstableTemplates<TContentProcessor, TRequest> templates;
        templates.emplace_back(t1);
        templates.emplace_back(t2);
        const auto result = Op.GetBestMatch(Context, msg, templates);
        EXPECT_FALSE(result.has_value());
    }

    void NoMatchWithTemplatesWhichHaveNoRequiredCommonPart() {
        TCalculateBestMatchOperation<TContentProcessor, TRequest> Op(1.1, 0.6, 1);
        const auto sp = CreateContentProcessor(1);
        const auto msg = CreateMessagePtr("<1><2><3><4><5><6><7><8><9><10>", "", "", "", sp);
        auto t1 = CreateUnstableTemplate("", "", "", "", sp);
        auto t2 = CreateUnstableTemplate("<11><12><13>", "", "", "", sp);
        TUnstableTemplates<TContentProcessor, TRequest> templates;
        templates.emplace_back(t1);
        templates.emplace_back(t2);
        const auto result = Op.GetBestMatch(Context, msg, templates);
        EXPECT_FALSE(result.has_value());
    }
private:
    void AddHits(const TUnstableTemplatePtr& templatePtr, size_t hitsCount) {
        for (size_t i = 0; i < hitsCount; i++) {
            templatePtr->IncrementHits();
        }
    }

private:
    NTemplateMaster::TContextPtr Context;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TCalculateBestMatchOpTest)
