#include <mail/template_master/lib/template_pool/operations/save_ready_template.h>
#include <mail/template_master/ut/utils.h>
#include <mail/template_master/ut/mock/db_mock.h>

#include <library/cpp/testing/unittest/registar.h>

#include <memory>

namespace NTemplateMaster::NTests {

using NTemplateMaster::NTemplatePool::TSaveReadyTemplateOperation;
using ::testing::InvokeArgument;
using ::testing::_;

class TSaveReadyTemplateOpTest : public TTestBase {
    UNIT_TEST_SUITE(TSaveReadyTemplateOpTest)
        UNIT_TEST(Success)
        UNIT_TEST(Fail)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        Db = GetDbMock();
        Context = GetContext();
        Operation = std::make_unique<TSaveReadyTemplateOperation<TContentProcessor, TRequest>>(3);
    }

    void Success() {
        auto templ = CreateUnstableTemplate("", "", "", "", CreateContentProcessor(1));
        ASSERT_FALSE(templ->IsSaved());
        EXPECT_CALL(*Db, AsyncSaveTemplate(_, _, _, _, _))
                .WillOnce(InvokeArgument<4>(TExpected<void>{}));
        Operation->Save(Context, templ, Db);
        ASSERT_TRUE(templ->IsSaved());
    }

    void Fail() {
        auto templ = CreateUnstableTemplate("", "", "", "", CreateContentProcessor(1));
        ASSERT_FALSE(templ->IsSaved());
        EXPECT_CALL(*Db, AsyncSaveTemplate(_, _, _, _, _))
                .WillOnce(InvokeArgument<4>(yamail::make_unexpected(boost::system::error_code())));
        Operation->Save(Context, templ, Db);
        ASSERT_FALSE(templ->IsSaved());
    }
private:
    TDatabaseMockPtr Db;
    NTemplateMaster::TContextPtr Context;
    std::unique_ptr<TSaveReadyTemplateOperation<TContentProcessor, TRequest>> Operation;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TSaveReadyTemplateOpTest)
