#include <mail/template_master/lib/types/match/match_result.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

#include <vector>

namespace NTemplateMaster::NTests {

using ::NTemplateMaster::NUtils::InlineDiff;

Y_UNIT_TEST_SUITE(MatchResult) {

Y_UNIT_TEST(FullMatch) {
    const auto seq1 = BuildTokenSequence("1", "2", "3");
    const auto seq2 = BuildTokenSequence("1", "3", sentinel, "5");
    const auto seq3 = BuildTokenSequence(sentinel, "1", "2", sentinel);
    ::NTemplateMaster::TChunks<TStringToken> result;
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq2));
    TMatchResult<TStringToken> match(result);
    ASSERT_FALSE(match.IsFullMatch());
    result.clear();
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq3));
    TMatchResult<TStringToken> match2(result);
    ASSERT_TRUE(match2.IsFullMatch());
}

Y_UNIT_TEST(Delta) {
    const auto seq1 = BuildTokenSequence("1", "2", "3");
    const auto seq2 = BuildTokenSequence("1", "3", sentinel, "5");
    const auto seq3 = BuildTokenSequence(sentinel, "1", "6", sentinel, "9");
    ::NTemplateMaster::TChunks<TStringToken> result;
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq2));
    TMatchResult<TStringToken> match(result);
    const auto delta = match.GetDelta();
    ASSERT_EQ(delta, std::vector<std::vector<std::string>>({{"2"}, {}}));

    result.clear();
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq3));
    TMatchResult<TStringToken> match2(result);
    const auto delta2 = match2.GetDelta();
    ASSERT_EQ(delta2, std::vector<std::vector<std::string>>({{}, {"2", "3"}}));
}

Y_UNIT_TEST(CommonPart) {
    const auto seq1 = BuildTokenSequence("1", "2", "3");
    const auto seq2 = BuildTokenSequence("1", "3", sentinel, "5");
    const auto seq3 = BuildTokenSequence(sentinel, "1", "6", sentinel, "9");
    ::NTemplateMaster::TChunks<TStringToken> result;
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq2));
    TMatchResult<TStringToken> match(result);
    const auto commonPart = match.GetCommonPart();
    ASSERT_TRUE(Compare(commonPart, BuildTokenSequence(sentinel, "1", sentinel, "3", sentinel)));

    result.clear();
    InlineDiff(result, TConstArrayRef<TStringToken>(seq1), TConstArrayRef<TStringToken>(seq3));
    TMatchResult<TStringToken> match2(result);
    const auto commonPart2 = match2.GetCommonPart();
    ASSERT_TRUE(Compare(commonPart2, BuildTokenSequence(sentinel, "1", sentinel)));
}
}

}
