#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/lib/template_master/content_processor/email_attributes.h>
#include <mail/template_master/lib/types/template/message.h>
#include <mail/template_master/lib/types/template/unstable_template.h>

#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

namespace NTemplateMaster::NTests {

class TMessageTest : public TTestBase {
    UNIT_TEST_SUITE(TMessageTest)
        UNIT_TEST(Attributes)
        UNIT_TEST(UnstableTemplateCreate)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        ShingerPrint = CreateContentProcessor(3);
    }

    void Attributes() {
        auto msg = CreateMessage("one<test>two>", "3", "4", "5", ShingerPrint);
        const auto msg_attrs = msg.GetAttributes();
        TEmailAttributes attrs{"3", "4", "5", {}};
        ASSERT_EQ(msg_attrs, attrs);
    }

    void UnstableTemplateCreate() {
        TEmailAttributes attrs{"3", "4", "5", {}};
        const auto templ = CreateUnstableTemplate("one<test>two>", "3", "4", "5", ShingerPrint);

        ASSERT_EQ(templ->IsSaved(), false);
        ASSERT_EQ(templ->GetHits(), static_cast<size_t>(0));
        const auto templ_attrs = templ->GetAttributesArray();
        ASSERT_EQ(templ_attrs.size(), static_cast<size_t>(1));
        ASSERT_EQ(templ_attrs.at(0), attrs);
        const auto templ_tokens = templ->GetTokens();
        ASSERT_EQ(templ_tokens.size(), static_cast<size_t>(5));
        ASSERT_TRUE(templ_tokens.at(0).IsSentinel());
        ASSERT_TRUE(templ_tokens.at(1) == TStringToken("one"));
        ASSERT_TRUE(templ_tokens.at(2) == TStringToken("<test>"));
        ASSERT_TRUE(templ_tokens.at(3) == TStringToken("two>"));
        ASSERT_TRUE(templ_tokens.at(4).IsSentinel());
    }

private:
    TContentProcessorPtr ShingerPrint;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TMessageTest)
