#include <mail/template_master/lib/template_master/handlers/route_template_handler.h>
#include <mail/template_master/ut/environment.h>
#include <mail/template_master/ut/utils.h>

#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NTemplateMaster::NTests {

class TRouteRequestTest : public TTestBase {
    UNIT_TEST_SUITE(TRouteRequestTest)
        UNIT_TEST(RouteRequestSerializationDeserialization)
        UNIT_TEST(RouteRequestWithNoDbHintsSerializationDeserialization)
    UNIT_TEST_SUITE_END();
public:
    void RouteRequestSerializationDeserialization() {
        THttpRouteRequest routeRequest{"<!doctype html><meta charset=utf-8><title>html</title>", "from@ya.ru", "subject", "queueid", {"uid"}};

        TTemplateStableSign sign{100500};
        TTemplateFeaturesSet features{12345};
        std::string tokens{R"([["html"]])"};
        TJsonAttributesArray attributes{};
        TDbHints dbHints{TDbHint{sign, std::vector(features.begin(), features.end()), tokens, attributes.raw_string()}};
        THttpDetempleRequest detempleRequest{routeRequest, dbHints};

        auto serialized = yamail::data::serialization::toJson(detempleRequest).str();
        THttpDetempleRequest deserialized;
        yamail::data::deserialization::fromJson(serialized, deserialized);

        ASSERT_EQ(detempleRequest, deserialized);
    }

    void RouteRequestWithNoDbHintsSerializationDeserialization() {
        THttpRouteRequest routeRequest{"<!doctype html><meta charset=utf-8><title>html</title>", "from@ya.ru", "subject", "queueid", {"uid"}};

        THttpDetempleRequest detempleRequest{routeRequest, {}};

        auto serialized = yamail::data::serialization::toJson(detempleRequest).str();
        THttpDetempleRequest deserialized;
        yamail::data::deserialization::fromJson(serialized, deserialized);
        ASSERT_EQ(detempleRequest, deserialized);

        auto serializedRouteRequest = yamail::data::serialization::toJson(routeRequest).str();
        THttpDetempleRequest deserializedDetempleRequest;
        yamail::data::deserialization::fromJson(serializedRouteRequest, deserializedDetempleRequest);
        ASSERT_EQ(detempleRequest, deserializedDetempleRequest);
    }
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TRouteRequestTest);
