#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>

#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

#include <iostream>

namespace NTemplateMaster::NTests {

class TStableTemplateTest : public TTestBase {
    UNIT_TEST_SUITE(TStableTemplateTest)
        UNIT_TEST(BaseTest)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        ContentProcessor = CreateContentProcessor(3);
    }

    void BaseTest() {
        const std::string json = "[[\"one\",\"<test>\",\"two>\"], [\"1\"]]";
        TStableTemplate templ(*ContentProcessor, json, false);
        ASSERT_THROW(templ.UpdateTokens(BuildTokenSequence()), std::runtime_error);

        const auto tokens = templ.GetTokens();
        ASSERT_EQ(tokens.size(), static_cast<size_t>(7));
        ASSERT_TRUE(tokens.at(0).IsSentinel());
        ASSERT_TRUE(tokens.at(1) == TTokenType("one"));
        ASSERT_TRUE(tokens.at(2) == TTokenType("<test>"));
        ASSERT_TRUE(tokens.at(3) == TTokenType("two>"));
        ASSERT_TRUE(tokens.at(4).IsSentinel());
        ASSERT_TRUE(tokens.at(5) == TTokenType("1"));
        ASSERT_TRUE(tokens.at(6).IsSentinel());

        const auto digest = templ.GetFeatures();
        ASSERT_EQ(digest.size(), static_cast<size_t>(4));
        ASSERT_EQ(digest, TTemplateFeaturesSet({170614755, 206349347, 257233488, 261604818}));
    }

private:
    TContentProcessorPtr ContentProcessor;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TStableTemplateTest);
