#include <mail/template_master/lib/types/token/template_tokens.h>
#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

#include <vector>

namespace NTemplateMaster::NTests {

class TTemplateTokensTest : public TTestBase {
    UNIT_TEST_SUITE(TTemplateTokensTest)
        UNIT_TEST(BaseTest)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        ShingerPrint = CreateContentProcessor(3);
    }

    void BaseTest() {
        const auto tokenSequence = BuildTokenSequence(sentinel, "1", "2", sentinel, "3", sentinel);
        TStringTemplateTokens templateTokens(*ShingerPrint, tokenSequence);
        ASSERT_EQ(templateTokens.Size(), static_cast<size_t>(6));
        ASSERT_EQ(templateTokens.Json(), "[[\"1\",\"2\"],[\"3\"]]");
        const auto tokenSequence2 = BuildTokenSequence("3", "2", sentinel, "5");
        templateTokens.UpdateTokens(tokenSequence2);
        TTemplateFeaturesSet features{209839912, 239969207, 248298631};
        ASSERT_EQ(templateTokens.Size(), static_cast<size_t>(4));
        ASSERT_EQ(templateTokens.Json(), "[[\"3\",\"2\"],[\"5\"]]");
        ASSERT_EQ(templateTokens.GetFeatures(), features);
        ASSERT_EQ(templateTokens.GetStableSign(), 621232684477699174);
    }

private:
    TContentProcessorPtr ShingerPrint;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TTemplateTokensTest);
