#include <mail/template_master/lib/types/token/token.h>

#include <library/cpp/testing/unittest/gtest.h>

using TIntToken = NTemplateMaster::TToken<int>;

template<>
inline const int& NTemplateMaster::GetTokenValue(const TIntToken& token) {
    static const int kSentinelValue = 12345;
    return token.Value.has_value() ? token.Value.value() : kSentinelValue;
}

namespace NTemplateMaster::NTests {

Y_UNIT_TEST_SUITE(TokenConcept) {

Y_UNIT_TEST(Sentinel) {
    TIntToken sentinel;
    TIntToken other_sentinel;
    ASSERT_TRUE(sentinel.IsSentinel());
    ASSERT_EQ(sentinel.GetValue(), 12345);
    ASSERT_FALSE(sentinel == other_sentinel);
    ASSERT_TRUE(sentinel != other_sentinel);
}

Y_UNIT_TEST(SimpleToken) {
    TIntToken token(44);
    TIntToken token2(44);
    TIntToken token3(12);
    ASSERT_FALSE(token.IsSentinel());
    ASSERT_FALSE(token2.IsSentinel());
    ASSERT_EQ(token.GetValue(), 44);
    ASSERT_TRUE(token == token2);
    ASSERT_FALSE(token != token2);
    ASSERT_TRUE(token != token3);
}

Y_UNIT_TEST(Operations) {
    TIntToken sentinel;
    TIntToken token(44);
    TIntToken token2(20);
    TIntToken token3(64);
    ASSERT_TRUE(sentinel.IsSentinel());
    ASSERT_FALSE(token.IsSentinel());
    ASSERT_FALSE(token2.IsSentinel());
    ASSERT_FALSE(token3.IsSentinel());
    ASSERT_THROW(sentinel += token, std::runtime_error);
    ASSERT_THROW(sentinel + token2, std::runtime_error);
    ASSERT_TRUE((token + token2) == token3);
    ASSERT_TRUE((token += token2) == token3);
}
}

}
