#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/lib/template_master/content_processor/email_attributes.h>
#include <mail/template_master/lib/types/template/message.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

namespace NTemplateMaster::NTests {

class TUnstableTemplateTest : public TTestBase {
    UNIT_TEST_SUITE(TUnstableTemplateTest)
        UNIT_TEST(BaseTest)
    UNIT_TEST_SUITE_END();
public:
    void SetUp() override {
        ShingerPrint = CreateContentProcessor(3);
    }

    void BaseTest() {
        TAttributes attrs{"3", "4", "5", TUids({"123"})};
        const TRequest req{"one<test>two>", "3", "4", "5", TUids{}};
        const auto templ = CreateUnstableTemplate(req.Html, req.From, req.Subject, req.QueueId, ShingerPrint);

        ASSERT_EQ(templ->IsSaved(), false);
        ASSERT_EQ(templ->GetHits(), static_cast<size_t>(0));
        templ->SetSaved(true);
        ASSERT_EQ(templ->IsSaved(), true);
        templ->IncrementHits();
        templ->IncrementHits();
        templ->IncrementHits();
        ASSERT_EQ(templ->GetHits(), static_cast<size_t>(3));
        TAttributes attrs1{"1", "2", "3", TUids({"123"})}, attrs2{"4", "5", "6", TUids({"456"})};
        templ->PushAttributes(attrs1);
        templ->PushAttributes(attrs2);
        const auto templAttrs = templ->GetAttributesArray();
        ASSERT_EQ(templAttrs.size(), static_cast<size_t>(3));
        ASSERT_EQ(templAttrs.at(0), TAttributes(req.From, req.Subject, req.QueueId, req.Uids));
        ASSERT_EQ(templAttrs.at(1), attrs1);
        ASSERT_EQ(templAttrs.at(2), attrs2);
        const auto dbTemplate = templ->CreateDatabaseTemplate();
        ASSERT_EQ(dbTemplate->Json(), "[[\"one\",\"<test>\",\"two>\"]]");
        ASSERT_EQ(dbTemplate->GetStableSign(), 990952002904229251);
        ASSERT_EQ(dbTemplate->GetFeatures(), TTemplateFeaturesSet({170614755, 257233488, 261604818}));

        auto newTokens = BuildTokenSequence("123", "345");
        templ->UpdateTokens(newTokens);
        ASSERT_TRUE(Compare(templ->GetTokens(), BuildTokenSequence("123", "345")));
        ASSERT_EQ(templ->GetFeatures(), TTemplateFeaturesSet({33737622, 226621889}));
    }

private:
    TContentProcessorPtr ShingerPrint;
};

}

UNIT_TEST_SUITE_REGISTRATION(NTemplateMaster::NTests::TUnstableTemplateTest);
