#pragma once
#include <mail/template_master/lib/template_master/content_processor/shinger_print.h>
#include <mail/template_master/lib/types/operation_request/email_http_request.h>
#include <mail/template_master/lib/template_master/content_processor/email_attributes.h>
#include <mail/template_master/lib/types/template/message.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/lib/template_pool/template_pool.h>
#include <mail/template_master/lib/types/log.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/db/database_module.h>
#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

#include <util/random/random.h>
#include <util/stream/output.h>

#include <memory>

namespace NTemplateMaster::NTests {

using TRequest = ::NTemplateMaster::THttpRouteRequest;

using TContentProcessor = ::NTemplateMaster::TShingerPrint;
using TContentProcessorPtr = ::NTemplateMaster::TShingerPrintPtr;

using TTokenType = TStringToken;
using TUnstableTemplatePtr = ::NTemplateMaster::TUnstableTemplatePtr<TContentProcessor, TRequest>;

using TMessage = ::NTemplateMaster::TMessage<TContentProcessor, TRequest>;
using TMessagePtr = std::shared_ptr<TMessage>;


using TStableTemplate = ::NTemplateMaster::TStableTemplate<TContentProcessor, TRequest>;
using TStableTemplatePtr = ::NTemplateMaster::TStableTemplatePtr<TContentProcessor, TRequest>;
using TStableTemplates = ::NTemplateMaster::TStableTemplates<TContentProcessor, TRequest>;

template<typename T>
using TTemplatePoolPtr = ::NTemplateMaster::NTemplatePool::TTemplatePoolPtr<TContentProcessor, TRequest, T>;

using TStringTemplateTokens = TTemplateTokens<TContentProcessor, TRequest>;
using TAttributes = ContentProcessorAttributesType<TContentProcessor, TRequest>;

using TStringTokenSequence = ::NTemplateMaster::TTokenSequence<TTokenType>;

using ::NTemplateMaster::TTemplateFeaturesSet;
using ::NTemplateMaster::TTemplateFeaturesVector;

inline auto CreateMessage(std::string html,
        std::string from,
        std::string subject,
        std::string queueId,
        TContentProcessorPtr shingerPrint) {
    const TRequest request{html, from, subject, queueId, {}};
    return TMessage(*shingerPrint, request);
}

template<typename... Ts>
inline auto CreateMessagePtr(Ts&&... args) {
    return std::make_shared<TMessage>(CreateMessage(std::forward<Ts>(args)...));
}

template<typename... Ts>
inline auto CreateUnstableTemplate(Ts... args) {
    return CreateMessage(std::forward<Ts>(args)...).CreateUnstableTemplate();
}

class THasher {
public:
    template<typename It>
    auto operator()(It begin, It end) const {
        size_t result = 0;
        for (auto it = begin; it != end; it++) {
            result += *it;
        }
        return result;
    }
};

inline auto GetContext() {
    return boost::make_shared<NTemplateMaster::TContext>(boost::make_shared<ymod_webserver::context>(), "");
}

inline auto CreateContentProcessor(size_t max_equal_tokens) {
    return std::make_shared<TShingerPrint>(max_equal_tokens);
}

class TSentinel {};

template<typename T>
struct BuildToken {};

template<>
struct BuildToken<const char*> {
    template<typename TArg>
    static TTokenType apply(TArg&& arg) {
        return TTokenType(std::forward<TArg>(arg));
    }
};

template<>
struct BuildToken<TSentinel> {
    template<typename TArg>
    static TTokenType apply(TArg&&) {
        return TTokenType();
    }
};

constexpr auto sentinel = TSentinel{};

template<typename... TArgs>
auto BuildTokenSequence(TArgs&&... args) {
    return TStringTokenSequence({BuildToken<std::decay_t<TArgs>>::apply(std::forward<TArgs>(args))...});
}

inline auto BuildRandomTokensSequence() {
    TStringTokenSequence result;
    size_t tokensCount = RandomNumber<uint8_t>() + 1;
    while (tokensCount--) {
        result.emplace_back(std::to_string(RandomNumber<uint16_t>()));
    }
    return result;
}

inline auto BuildRandomTemplateTokens() {
    size_t sentinelCount = RandomNumber<uint8_t>() + 1;
    TStringTokenSequence result;
    result.emplace_back();
    while (sentinelCount--) {
        auto tokens = BuildRandomTokensSequence();
        result.insert(result.end(), tokens.begin(), tokens.end());
        result.emplace_back();
    }
    return result;
}

template<typename T>
inline bool Compare(const T& left, const T& right);

template<>
inline bool Compare(const TStringTokenSequence& seq1, const TStringTokenSequence& seq2) {
    if (seq1.size() != seq2.size()) {
        return false;
    }
    for (size_t i = 0; i < seq1.size(); i++) {
        if (seq1.at(i).GetValue() != seq2.at(i).GetValue()) {
            return false;
        }
    }
    return true;
}

class TWithSpawn {
public:
    template <typename TFunc>
    void Spawn(TFunc&& func) {
        boost::asio::spawn(*Io, std::forward<TFunc>(func), boost::coroutines::attributes(1e8));
        Io->run();
    }
protected:
    std::unique_ptr<boost::asio::io_context> Io;
};

}

template <>
inline void Out<NTemplateMaster::NTests::TAttributes>(
    IOutputStream& o,
    const NTemplateMaster::NTests::TAttributes& attrs)
{
    o.Write(yamail::data::serialization::toJson(attrs).str());
}

template <>
inline void Out<::NTemplateMaster::TTemplateFeaturesSet>(
    IOutputStream& o,
    const ::NTemplateMaster::TTemplateFeaturesSet& features)
{
    o.Write(yamail::data::serialization::toJson(features).str());
}
