#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/ut/utils.h>

#include <library/cpp/testing/unittest/gtest.h>

#include <vector>

namespace NTemplateMaster::NTests {

using namespace NTemplateMaster::NUtils;

Y_UNIT_TEST_SUITE(MatchDbTemplate) {

Y_UNIT_TEST(ContainsOnlyTemplate) {
    auto msgTokens = BuildTokenSequence("1", "2", "5", "3", "4");
    auto templTokens = BuildTokenSequence(sentinel, "1", "2", sentinel, "5", "3", "4", sentinel);
    auto delta = MatchDbTemplate(msgTokens, templTokens);
    EXPECT_TRUE(delta.has_value());
    std::vector<std::vector<std::string>> expectDelta({{}, {}, {}});
    EXPECT_EQ(delta.value(), expectDelta);
}

Y_UNIT_TEST(RegressContainsTemplate) {
    constexpr auto iterations = (1 << 5);
    for (auto it = 0; it < iterations; it++) {
        auto templTokens = BuildRandomTemplateTokens();
        TStringTokenSequence msgTokens;
        for (auto&& token : templTokens) {
            if (token.IsSentinel()) {
                auto tokens = BuildRandomTokensSequence();
                msgTokens.insert(msgTokens.end(), tokens.begin(), tokens.end());
            } else {
                msgTokens.emplace_back(token);
            }
        }
        auto optDelta = MatchDbTemplate(msgTokens, templTokens);
        EXPECT_TRUE(optDelta.has_value());
        TStringTokenSequence expectMsgTokens;
        size_t pos = 0;
        const auto delta = optDelta.value();
        for (auto&& token : templTokens) {
            if (token.IsSentinel()) {
                expectMsgTokens.insert(expectMsgTokens.end(), delta[pos].begin(), delta[pos].end());
                pos++;
            } else {
                expectMsgTokens.emplace_back(token);
            }
        }
        EXPECT_TRUE(Compare(expectMsgTokens, msgTokens));
    }
}

Y_UNIT_TEST(ContainsOnlyTemplate2) {
    auto msgTokens = BuildTokenSequence("1");
    auto templTokens = BuildTokenSequence(sentinel, "1", sentinel);
    auto delta = MatchDbTemplate(msgTokens, templTokens);
    EXPECT_TRUE(delta.has_value());
    std::vector<std::vector<std::string>> expectDelta({{}, {}});
    EXPECT_EQ(delta.value(), expectDelta);
}

Y_UNIT_TEST(ContainsTemplateWithDiff) {
    auto msgTokens = BuildTokenSequence("diff0", "1", "2", "diff1.1", "diff1.1",
        "3", "4", "5", "6", "diff3.1", "diff3.2", "diff3.3");
    auto templTokens = BuildTokenSequence(sentinel, "1", "2", sentinel,
        "3", "4", "5", sentinel, "6", sentinel);
    auto delta = MatchDbTemplate(msgTokens, templTokens);
    EXPECT_TRUE(delta.has_value());
    std::vector<std::vector<std::string>> expectDelta({{"diff0"},
                                                       {"diff1.1", "diff1.1"}, {},
                                                       {"diff3.1", "diff3.2", "diff3.3"}});
    EXPECT_EQ(delta.value(), expectDelta);
}

Y_UNIT_TEST(NotMatched) {
    auto msgTokens = BuildTokenSequence("1", "3");
    auto templTokens = BuildTokenSequence(sentinel, "1", sentinel, "2", sentinel);
    auto delta = MatchDbTemplate(msgTokens, templTokens);
    EXPECT_FALSE(delta.has_value());
}
}

}
