UNITTEST_FOR(mail/template_master/lib)

OWNER(g:so)

PEERDIR(
    library/cpp/testing/gmock_in_unittest
    library/cpp/testing/unittest
)

SRCS(
    db/find_template_by_stable_sign_ut.cpp
    db/delete_template_ut.cpp
    db/find_similar_templates_ut.cpp
    db/save_template_ut.cpp
    db/update_search_flag_ut.cpp
    db/merge_templates_ut.cpp
    db/connection_provider_ut.cpp

    template_pool/calculate_best_match_ut.cpp
    template_pool/get_candidate_templates_ut.cpp
    template_pool/template_pool_ut.cpp
    template_pool/minhash_ut.cpp
    template_pool/save_ready_template_ut.cpp
    template_pool/template_cache_ut.cpp

    types/match_result_ut.cpp
    types/message_ut.cpp
    types/stable_template_ut.cpp
    types/token_ut.cpp
    types/template_tokens_ut.cpp
    types/unstable_template_ut.cpp
    types/operation_result_ut.cpp
    types/operation_request_ut.cpp

    template_master/shinger_print_ut.cpp
    template_master/find_template_handler_ut.cpp
    template_master/delete_template_handler_ut.cpp
    template_master/detemple_handler_ut.cpp
    template_master/route_handler_ut.cpp
    template_master/merge_templates_ut.cpp

    router/node_ut.cpp
    router/node_manager_ut.cpp
    router/retry_ut.cpp

    utils/match_db_template_ut.cpp
)

CFLAGS(
    -DBOOST_HANA_CONFIG_ENABLE_STRING_UDL
    -Wno-gnu-string-literal-operator-template
)

END()
