# Тестопитек

### Как настроить Тестопитек
- Получите любую роль в сервисе в [ABC](https://abc.yandex-team.ru/services/testopithecus/)
- Если вы первый раз работаете с Аркадией, то настройте ssh ключи https://wiki.yandex-team.ru/arcadia/starterguide/#ssh
- Скачиваем репозиторий Тестопитека из Аркадии
```
svn co svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/mail/testopithecus
```
- Скачиваем WebStorm и открываем в нем проект
- Устанавливаем плагин `Bash Support`
- Устанавливаем последний `XCode` и `CommandLineTools`
- Устанавливаем зависимости проекта - запускаем конфигурацию `Setup Project` справа сверху
- Для получения обновлений используйте `svn up .` или `command + t` в WebStorm
- Для игнорирования файлов svn-ом откройте снизу вкладку `Version Control` -> пкм на ненужной папке 
(`node_modules`, `build` и т.п.) -> `Ignore all files under` -> `OK`

### Как проверить валидность модели и кросс-платформенных тестов
Для этого можно запустить все тесты в режиме "модель" против "модели"
Выбираем и запускаем конфигурацию `Run all tests on Model` из списка конфигураций справа сверху.
Тесты используют некоторые сервисы, доступы к которым должны прорасти через некоторое время после получения роли в ABC.

### Как запустить тесты на бэкенд
Выбираем и запускаем конфигурацию `Run all tests on Mobile API` из списка справа сверху (см. `backend.ts`). 
Автотесты запустятся на случайном пользователе из пула. Его логин пароль будет в одной из первых строчек логов:
`Got account login=yandex-team-12993-09775 password=simple123456 uid=946220544`

### Хочу протестировать новую функциональность
Перед началом прочтите [обзорную статью](https://clubs.at.yandex-team.ru/mail/25713) про тестирование на основе модели.

Для того, чтобы протестировать новую функциональность надо добавить фичу, реализовать ее в модели и в приложении, 
сделать действия и составить из них несколько кросс-платформенных тестов.
`Фича` - некий кусок функциональности тестируемого приложения, представленный в Тестопитеке произвольным интерфейсом. Примеры фичей живут `mail-features.ts`.
У каждой фичи есть ее метаинформация (имя и пр.) - наследник класса `Feature`.
Для того, чтобы ваша функциональность могла быть протестирована, соответсвующая фича должна быть реализована и в модели, и в приложении.
Реализация фичи в модели добавляется через класс `MailboxModel` (там много примеров).
Реализация фичи в приложении добавляется в проекте ваших автотестов - через класс `MobileMailBackend` для мобильного API, `AndroidMailboxApplication.kt` для Android и `IOSMailboxApplication.swift` для iOS.
Методы фичи, которые меняют состояние приложения, следует завернуть в `Действия` (`MBTAction`).
Действие переводит приложение из одного компонента в другой компонент (`MBTComponent`) после выполнения метода `perform`.
По сути, компонент - это один из экранов приложения.
Все проверки записываются в `assertMatches` у соответствующего компонента. Проверки должны использовать read-only методы вашей фичи.
Для каждого мутабельного метода вашей фичи надо сделать наследника `MBTAction`. В папке `actions` есть много примеров. 
Дальше можно написать кросс-платформенный тест, который протестирует вашу функциональность (см. папку `tests`).
Каждый тест - это просто последовательность action-ов. Платформа сама будет вызывать `assertMatches` между действиями при прогоне теста.

Итого, чтобы протестировать вашу функциональность надо:
- Добавить фичу в `mail-features.ts`
- Добавить ее реализацию в `MailboxModel`
- Если надо, написать новый компонент `MBTComponent`
- Создать несолько `MBTAction` для действий в вашей функциональности
- Написать несколько `MBTTest`-ов при помощи новых `MBTAction`-ов
- Запустить проверку их валидности - конфигурацию `Run all tests on Model`
- Странслировать полученный код в ваши автотесты (см. соответствующие разделы ридми)
- Реализовать и зарегестрировать фичу уже в автотестах для интересующей платформы
- Позапускать свои тесты (см. `Как запустить один кросс-платформенный тест`)

Такой подход позволяет автоматически генерировать автотесты для вашей функциональности.
Платформа сама это сделает. Кроме того, она сгенерирует так называемый "умный обход", который протестирует все возможные состояния вашей фичи. 


### Как написать кросс-платформенный тест
Если у вас обычный тест, который использует один яндексовый аккаунт, то надо в папке `code/tests` 
реализовать класс-наследник `RegularYandexTestBase`. Там много подобных примеров.
Если ваш тест более сложный, то надо отнаследоваться от `AbstractMBTTest` 
Если у вашего теста есть братишка в Пальме, то вы можете переопределить метод `testSettings` - он должен вернуть конфиг с id соответсвующих кейсов.
Пример такого теста - `InboxTopBarDisplayTest` из `inbox-top-bar-display-test.ts`
Реализованный тест следует зарегистрировать в `register-your-test-here.ts`

### Как запустить один кросс-платформенный тест
Все тесты регистрируются в `register-your-test-here.ts` и на каждой платформе запускаются всем скопом под одним параметризированным тестом
(см. `TestopithecusFixedScenarioTests.swift / TestopithecusFixedScenarioTests.kt / backend.ts`).
Для запуска одного теста раскомментируйте строку с `TestsRegistry.testToDebug` и в качестве значения укажите свой тест.
После чего запустите конфигурацию с тестопитековскими тестами (`Run Testopithecus Tests` в Android, 
`TestopithecusFixedScenarioTests [Debug]` в iOS и `Run all tests on Mobile API` для бэкенда)

### Скачиваем и устанавливаем транслятор
- Устанаваливаем git-lfs: `brew install git-lfs && git lfs install`
- Скачиваем монорепу, если ее нет `git clone ssh://git@bb.yandex-team.ru/mobile/monorepo.git`
- Открываем проект XMail в WebStorm. Он лежит по пути `mail/common/xmail`
- Устаналиваем все зависимости через `yarn install`
- Открываем `packages/ys/package.json`
- Компилируем код транслятора из typescript в javascript вызовом `build` из `scripts`
- В результате должна появиться входная точка транслятора - файл `packages/ys/build/src/app.js`

### Генерим код для Android автотестов
- Скачиваем код автотестов https://github.yandex-team.ru/mobmail/mobmail-autotests и кладем в соседнюю для `testopithecus` папку
- Переключаемся на ветку `feature/mailbox-preparer`
- Возвращаемся обратно в Тестопитек
- Теперь можно запустить транслятор - конфигурация `Generate code for mobmail Android autotests` из списка справа сверху. 
- В ней надо будет немного поправить пути. Для этого давайте изучим ее подробнее:
##### Команда запуска транслятора
```
node /Users/amosov-f/Documents/yandex/monorepo/mail/common/xmail/packages/ys/build/src/app.js -i /Users/amosov-f/Documents/yandex/mail/testopithecus/common/code -o ../mobmail-autotests/android-core/src/main/java/ru/yandex/mobmail/testopithecus/generated -g /Users/amosov-f/Documents/yandex/monorepo/mail/common/xmail/packages/ys/build/src/generators/kotlin -c codegen/android.json -s
```
- `node` - программа запуска `JavaScript`
- `app.js` - программа траслятора
- `-i` - путь до транслируемого `TypeScript` кода
- `-o` - путь, где должен появиться транслированный код
- `-g` - путь до файла, соответствующего языку, в который мы транслируем
- `-c` - путь до конфига транслятора, в котором указывается информация, специфичная нашей задаче. В данном примере в нем указано, какой пакет будет у всех `kotlin` классов и какие дополнительные `import`-ы надо в начало каждого вставлять.
- `-s` - отключить кеширование у траслятора

- Исправляем пути и запускаем эту конфигурацию
- После отработки транслятора в папке, указанной за `-o`, появятся классы из папки `common/code`, но на нужном вам языке.
- Теперь вы можете их использовать в ваших тестах. Profit!

### Как обновить кросс-платформенный код для iOS автотестов
- В Xcode открываем Preferences -> Locations -> Command Line Tools и проверяем, чтобы там не было пустой строки
- Редактируем конфигурацию `Generate code for iOS` - прописываем путь до транслятора в `Environment variables`
- Запускаем генерацию и трансляцию swift-а - конфигурацию `Generate code for iOS`
- Коммитим сгенеренный swift и изменения в коде Тестопитека через пул реквест (см. `Как сделать пул-реквест в Testopithecus`)
- Скачиваем и устанавливаем AppCode
- Открываем в нем код iOS приложения - файл `mail/ios/mail-app/YandexMobileMail/YandexMobileMail.xcworkspace`
- Устанавливаем `cocoapods` по инструкции из ридми приложения. Если что-то не получается то Тимур может помочь
- Меняем ревизию `testopithecus` в [Podfile](https://bitbucket.browser.yandex-team.ru/projects/MA/repos/mobile-mail-client-ios/browse/YandexMobileMail/Podfile#95) на последнюю ревизию Аркадии - 
ее можно посмотреть справа сверху на морде Аркадии https://a.yandex-team.ru/
- Скачиваем новый код для автотестов через `pod install --repo-update`
- Если получаете ошибку `Unable to connect to a repository ...`, то попробуйте залогинится в svn. Проще всего попробовать скачать какую-нибудь папку
```
svn co https://arcadia.yandex.ru/arc/trunk/arcadia/mail/testopithecus/ios
```
ввести credentials, после чего ее удалить
- Делаем пул-реквест в проект iOS приложения - коммитим все изменения в pod-ке Тестопитека. Добавляем в ревьюеры Тимура. 

### Как сделать пул-реквест в Testopithecus
- Прогоняем тесты (`npm test` в консоли, или зеленая стрелочка рядом с `script -> test` в `package.json`)
- Запускаем конфигурацию `Generate code for iOS`
- Все новые и изменившиеся файлы (в т.ч. на swift) коммитим с текстом `Some message REVIEW:NEW`
- Важно: убеждаемся, что во вкладке снизу `Version Control` в разделе `Unversioned Files` нет незакоммиченных файлов с исходным кодом 
- Аркадия не даст закоммитить и в ошибке пришлет ссылку на ревью
- Добавляем `amosov-f` и `a-zoshchuk` в ревью
- Делаем `Publish` 
- Если надо внести правки в код на ревью, то надо сделать коммит с текстом `Some message REVIEW_UPLOAD:ID`, где `ID` - id пул реквеста из урла 
- Больше инфы про ревью в [инструкции](https://wiki.yandex-team.ru/arcadia/review/)
- После мержа пул-реквеста все тесты автоматически прогонятся в [TeamCity](https://teamcity.yandex-team.ru/viewType.html?buildTypeId=mobile_yandex_mail_clients_Testopithecus_TestTypescript)
- Убеждаемся, что ваш коммит их не сломал.

### Как получить OAuth токен пользователя по логину-паролю
OAuth токен можно получить, выполнив такой запрос 
```
curl -v -F grant_type=password -F username=LOGIN -F password=PASSWORD -F client_id=e7618c5efed842be839cc9a580be94aa -F client_secret=81a97a4e05094a4c96e9f5fa0b21f794 "https://oauth.yandex.ru/token"
```

### Как нарисовать граф
- Запускаем `Print model graph`, после выполнения должен появиться файл `graph.txt`
- В консоли выполняем команду `dot -ofile -O -Tpng graph.txt`, после выполнения должен появиться файл `graph.txt.png`
- PROFIT

### Публикации
https://clubs.at.yandex-team.ru/mail/25713
https://clubs.at.yandex-team.ru/mail/25718
