// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/contact/contact.ts >>>

import Foundation

open class Contact {
  public let cid: ID
  public let email: String
  public init(_ cid: ID, _ email: String) {
    self.cid = cid
    self.email = email
  }

  @discardableResult
  open func copy() -> Contact {
    return Contact(cid, email)
  }

  @discardableResult
  open func tostring() -> String {
    return "Contact(\(cid) \(email))"
  }
}

@discardableResult
public func contactFromJSONItem(_ item: JSONItem) -> Contact! {
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  let cid = idFromString(int64ToString(map.getInt64("cid")!))!
  let email = emailStringFromJSONItem(map.get("email")!)!
  return Contact(cid, email)
}

@discardableResult
public func emailStringFromJSONItem(_ item: JSONItem) -> String! {
  if item.kind == JSONItemKind.array {
    let array = item as! ArrayJSONItem
    return emailStringFromJSONItem(array.get(0))
  }
  if item.kind == JSONItemKind.string {
    let str = item as! StringJSONItem
    return str.value
  }
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  return map.getString("value")!
}

@discardableResult
public func emailStringFromContact(_ contact: Contact) -> String {
  return contact.email
}
