// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/container/container.ts >>>

import Foundation

open class Container {
  public let stats: ContainerStats
  public let folders: YSArray<FolderDTO>
  public let labels: YSArray<Label>
  public init(_ stats: ContainerStats, _ folders: YSArray<FolderDTO>, _ labels: YSArray<Label>) {
    self.stats = stats
    self.folders = folders
    self.labels = labels
  }
}

@discardableResult
public func containerFromJSONItem(_ item: JSONItem) -> Container! {
  if item.kind != JSONItemKind.array {
    return nil
  }
  let array = item as! ArrayJSONItem
  let containerStats: ContainerStats! = containerStatsFromJSONItem(array.get(0))
  if containerStats == nil {
    return nil
  }
  let folders: YSArray<FolderDTO> = YSArray()
  let labels: YSArray<Label> = YSArray()
  if containerStats.status.code == NetworkStatusCode.ok {
    for value in array.asArray() {
      let map = value as! MapJSONItem
      if map.hasKey("fid") {
        folders.push(folderFromJSONItem(map)!)
      } else if map.hasKey("lid") {
        labels.push(labelFromJSONItem(map)!)
      }
    }
  }
  return Container(containerStats, folders, labels)
}
