// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/container/container-stats.ts >>>

import Foundation

open class ContainerStatsPayload {
  public let md5: String
  public let mailboxRevision: Int64
  public init(_ md5: String, _ mailboxRevision: Int64) {
    self.md5 = md5
    self.mailboxRevision = mailboxRevision
  }
}

open class ContainerStats {
  public let status: NetworkStatus
  public let payload: ContainerStatsPayload!
  public init(_ status: NetworkStatus, _ payload: ContainerStatsPayload!) {
    self.status = status
    self.payload = payload
  }
}

@discardableResult
public func containerStatsFromJSONItem(_ item: JSONItem) -> ContainerStats! {
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  let status = networkStatusFromJSONItem(map.get("status")!)!
  if status.code != NetworkStatusCode.ok {
    return ContainerStats(status, nil)
  }
  let md5 = map.getString("md5")!
  let mailboxRevision = map.getInt64("mailbox_revision")!
  return ContainerStats(status, ContainerStatsPayload(md5, mailboxRevision))
}
