// <<< AUTOGENERATED BY YANDEX.SCRIPT FROM client/folder/folderDTO.ts >>>

import Foundation

public enum FolderType: Int32, Codable {
  case inbox = 1
  case user = 2
  case outgoing = 3
  case sent = 4
  case draft = 5
  case spam = 6
  case trash = 7
  case archive = 8
  case templates = 9
  case discount = 10
  case other = 11
  case unsubscribe = 12
  case tab_relevant = 100
  case tab_news = 101
  case tab_social = 102
  public func toInt() -> Int32 {
    return rawValue
  }
}

@discardableResult
public func int32ToFolderType(_ value: Int32) -> FolderType {
  switch value {
  case 1:
    return FolderType.inbox
  case 2:
    return FolderType.user
  case 3:
    return FolderType.outgoing
  case 4:
    return FolderType.sent
  case 5:
    return FolderType.draft
  case 6:
    return FolderType.spam
  case 7:
    return FolderType.trash
  case 8:
    return FolderType.archive
  case 9:
    return FolderType.templates
  case 10:
    return FolderType.discount
  case 11:
    return FolderType.other
  case 12:
    return FolderType.unsubscribe
  case 100:
    return FolderType.tab_relevant
  case 101:
    return FolderType.tab_news
  case 102:
    return FolderType.tab_social
  default:
    return FolderType.other
  }
}

@discardableResult
public func folderTypeToInt32(_ value: FolderType) -> Int32 {
  switch value {
  case FolderType.inbox:
    return 1
  case FolderType.user:
    return 2
  case FolderType.outgoing:
    return 3
  case FolderType.sent:
    return 4
  case FolderType.draft:
    return 5
  case FolderType.spam:
    return 6
  case FolderType.trash:
    return 7
  case FolderType.archive:
    return 8
  case FolderType.templates:
    return 9
  case FolderType.discount:
    return 10
  case FolderType.other:
    return 11
  case FolderType.unsubscribe:
    return 12
  case FolderType.tab_relevant:
    return 100
  case FolderType.tab_news:
    return 101
  case FolderType.tab_social:
    return 102
  }
}

@discardableResult
public func isFolderOfThreadedType(_ type: FolderType) -> Bool {
  switch type {
  case FolderType.trash:
    return false
  case FolderType.outgoing:
    return false
  case FolderType.templates:
    return false
  case FolderType.draft:
    return false
  case FolderType.spam:
    return false
  default:
    return true
  }
}

@discardableResult
public func isFolderOfTabType(_ type: FolderType) -> Bool {
  switch type {
  case FolderType.tab_relevant:
    return true
  case FolderType.tab_news:
    return true
  case FolderType.tab_social:
    return true
  default:
    return false
  }
}

public enum FolderSyncType: Int32, Codable {
  case doNotSync = 0
  case silentSync = 1
  case pushSync = 2
  public func toInt() -> Int32 {
    return rawValue
  }
}

@discardableResult
public func int32ToFolderSyncType(_ value: Int32) -> FolderSyncType {
  switch value {
  case 0:
    return FolderSyncType.doNotSync
  case 1:
    return FolderSyncType.silentSync
  case 2:
    return FolderSyncType.pushSync
  default:
    fatalError("Unknown FolderSyncType for \(value)")
  }
}

@discardableResult
public func folderSyncTypeToInt32(_ value: FolderSyncType) -> Int32 {
  switch value {
  case FolderSyncType.doNotSync:
    return 0
  case FolderSyncType.silentSync:
    return 1
  case FolderSyncType.pushSync:
    return 2
  }
}

open class FolderDTO {
  public let fid: ID
  public let type: FolderType
  public let name: String!
  public let position: Int32
  public let parent: ID!
  public let unreadCounter: Int32
  public let totalCounter: Int32
  public init(_ fid: ID, _ type: FolderType, _ name: String!, _ position: Int32, _ parent: ID!, _ unreadCounter: Int32, _ totalCounter: Int32) {
    self.fid = fid
    self.type = type
    self.name = name
    self.position = position
    self.parent = parent
    self.unreadCounter = unreadCounter
    self.totalCounter = totalCounter
  }
}

@discardableResult
public func folderFromJSONItem(_ item: JSONItem) -> FolderDTO! {
  if item.kind != JSONItemKind.map {
    return nil
  }
  let map = item as! MapJSONItem
  let fid = idFromString(map.getString("fid")!)!
  let parent: Int64! = idFromString(nullIfEmptyString(map.getString("parent")!))
  let name: String! = map.getString("display_name")
  let unread = map.getInt32("count_unread")!
  let total = map.getInt32("count_all")!
  let type = int32ToFolderType(map.getInt32("type")!)
  let position = stringToInt32((map.getMap("options")!.get("position")! as! StringJSONItem).value)!
  return FolderDTO(fid, type, name, position, parent, unread, total)
}
